/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.pakourblocks.client.model;

import com.mojang.logging.LogUtils;
import de.sarocesch.pakourblocks.block.ParkourBlock;
import de.sarocesch.pakourblocks.block.ParkourBlockEntity;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="saroparkourblocks", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class RenderTypeHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String MODID = "saroparkourblocks";

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            Block parkourBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(MODID, "parkour_block"));
            if (parkourBlock != null) {
                ItemBlockRenderTypes.setRenderLayer((Block)parkourBlock, renderType -> true);
                LOGGER.info("Set parkour block to render in all render types");
            }
        });
    }

    @SubscribeEvent
    public static void onRegisterBlockColors(RegisterColorHandlersEvent.Block event) {
        Block parkourBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(MODID, "parkour_block"));
        if (parkourBlock != null) {
            event.register((state, level, pos, tintIndex) -> {
                ParkourBlockEntity parkourBlockEntity;
                BlockState disguiseState;
                BlockEntity patt2758$temp;
                if (state != null && ((Boolean)state.m_61143_((Property)ParkourBlock.DISGUISED)).booleanValue() && level != null && pos != null && (patt2758$temp = level.m_7702_(pos)) instanceof ParkourBlockEntity && (disguiseState = (parkourBlockEntity = (ParkourBlockEntity)patt2758$temp).getDisguiseState()) != null) {
                    return event.getBlockColors().m_92577_(disguiseState, level, pos, tintIndex);
                }
                return -1;
            }, new Block[]{parkourBlock});
            LOGGER.info("Registered block color handler for parkour block");
        }
    }
}

