/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.pakourblocks.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.sarocesch.pakourblocks.block.ParkourBlock;
import de.sarocesch.pakourblocks.block.ParkourBlockEntity;
import de.sarocesch.pakourblocks.config.ModConfig;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParkourBlockRenderer
implements BlockEntityRenderer<ParkourBlockEntity> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParkourBlockRenderer.class);
    private final BlockRenderDispatcher blockRenderer;

    public ParkourBlockRenderer(BlockEntityRendererProvider.Context context) {
        this.blockRenderer = context.m_173584_();
    }

    public void render(ParkourBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        BlockState disguiseState;
        block7: {
            BlockState currentState = blockEntity.m_58900_();
            if (!((Boolean)currentState.m_61143_((Property)ParkourBlock.DISGUISED)).booleanValue()) {
                return;
            }
            disguiseState = blockEntity.getDisguiseState();
            if (disguiseState == null) {
                try {
                    ParkourBlock.DisguiseType disguiseType = (ParkourBlock.DisguiseType)((Object)currentState.m_61143_(ParkourBlock.DISGUISE_TYPE));
                    String blockId = disguiseType.getBlockId();
                    ResourceLocation blockResLoc = ResourceLocation.m_135820_((String)blockId);
                    if (blockResLoc != null) {
                        Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(blockResLoc);
                        disguiseState = block.m_49966_();
                        if (ModConfig.debugMode) {
                            LOGGER.info("Recreated disguise state from disguise type: {} -> {}", (Object)disguiseType, (Object)disguiseState.m_60734_().m_49954_().getString());
                        }
                        blockEntity.setDisguiseState(disguiseState);
                    }
                }
                catch (Exception e) {
                    if (!ModConfig.debugMode) break block7;
                    LOGGER.error("Error recreating disguise state: {}", (Object)e.getMessage());
                }
            }
        }
        if (disguiseState == null) {
            return;
        }
        BakedModel model = this.blockRenderer.m_110910_(disguiseState);
        TextureAtlasSprite spriteUp = this.getSprite(model, disguiseState, Direction.UP);
        TextureAtlasSprite spriteDown = this.getSprite(model, disguiseState, Direction.DOWN);
        TextureAtlasSprite spriteNorth = this.getSprite(model, disguiseState, Direction.NORTH);
        TextureAtlasSprite spriteSouth = this.getSprite(model, disguiseState, Direction.SOUTH);
        TextureAtlasSprite spriteWest = this.getSprite(model, disguiseState, Direction.WEST);
        TextureAtlasSprite spriteEast = this.getSprite(model, disguiseState, Direction.EAST);
        int tintIndexUp = this.getTintIndex(model, disguiseState, Direction.UP);
        int tintIndexDown = this.getTintIndex(model, disguiseState, Direction.DOWN);
        int tintIndexNorth = this.getTintIndex(model, disguiseState, Direction.NORTH);
        int tintIndexSouth = this.getTintIndex(model, disguiseState, Direction.SOUTH);
        int tintIndexWest = this.getTintIndex(model, disguiseState, Direction.WEST);
        int tintIndexEast = this.getTintIndex(model, disguiseState, Direction.EAST);
        Level level = blockEntity.m_58904_();
        BlockPos pos = blockEntity.m_58899_();
        BlockColors blockColors = Minecraft.m_91087_().m_91298_();
        int tintUp = this.getTintColor(blockColors, disguiseState, level, pos, tintIndexUp);
        int tintDown = this.getTintColor(blockColors, disguiseState, level, pos, tintIndexDown);
        int tintNorth = this.getTintColor(blockColors, disguiseState, level, pos, tintIndexNorth);
        int tintSouth = this.getTintColor(blockColors, disguiseState, level, pos, tintIndexSouth);
        int tintWest = this.getTintColor(blockColors, disguiseState, level, pos, tintIndexWest);
        int tintEast = this.getTintColor(blockColors, disguiseState, level, pos, tintIndexEast);
        int lightUp = 0xF000F0;
        int lightDown = 0xF000F0;
        int lightNorth = 0xF000F0;
        int lightSouth = 0xF000F0;
        int lightWest = 0xF000F0;
        int lightEast = 0xF000F0;
        RenderType renderType = RenderType.m_110451_();
        boolean renderUp = true;
        boolean renderDown = true;
        boolean renderNorth = true;
        boolean renderSouth = true;
        boolean renderWest = true;
        boolean renderEast = true;
        VertexConsumer vc = bufferSource.m_6299_(renderType);
        poseStack.m_85836_();
        this.renderCube(poseStack, vc, spriteUp, spriteDown, spriteNorth, spriteSouth, spriteWest, spriteEast, lightUp, lightDown, lightNorth, lightSouth, lightWest, lightEast, packedOverlay, tintUp, tintDown, tintNorth, tintSouth, tintWest, tintEast, renderUp, renderDown, renderNorth, renderSouth, renderWest, renderEast);
        poseStack.m_85849_();
    }

    private int getTintColor(BlockColors blockColors, BlockState state, Level level, BlockPos pos, int tintIndex) {
        if (level == null || tintIndex == -1) {
            return 0xFFFFFF;
        }
        return blockColors.m_92577_(state, (BlockAndTintGetter)level, pos, tintIndex);
    }

    private int getLightLevel(Level level, BlockPos pos, Direction direction) {
        return LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)pos);
    }

    private TextureAtlasSprite getSprite(BakedModel model, BlockState state, Direction face) {
        long rand = state.m_60726_(BlockPos.f_121853_);
        List quads = model.m_213637_(state, face, RandomSource.m_216335_((long)rand));
        if (!quads.isEmpty()) {
            return ((BakedQuad)quads.get(0)).m_173410_();
        }
        return model.m_6160_();
    }

    private int getTintIndex(BakedModel model, BlockState state, Direction face) {
        long rand = state.m_60726_(BlockPos.f_121853_);
        List quads = model.m_213637_(state, face, RandomSource.m_216335_((long)rand));
        if (!quads.isEmpty()) {
            return ((BakedQuad)quads.get(0)).m_111305_();
        }
        return -1;
    }

    private void renderCube(PoseStack pose, VertexConsumer vc, TextureAtlasSprite up, TextureAtlasSprite down, TextureAtlasSprite north, TextureAtlasSprite south, TextureAtlasSprite west, TextureAtlasSprite east, int lightUp, int lightDown, int lightNorth, int lightSouth, int lightWest, int lightEast, int overlay, int tintUp, int tintDown, int tintNorth, int tintSouth, int tintWest, int tintEast, boolean renderUp, boolean renderDown, boolean renderNorth, boolean renderSouth, boolean renderWest, boolean renderEast) {
        if (renderUp) {
            this.top(vc, pose, up, 1.0f, lightUp, overlay, tintUp);
        }
        if (renderDown) {
            this.bottom(vc, pose, down, 0.0f, lightDown, overlay, tintDown);
        }
        if (renderNorth) {
            this.north(vc, pose, north, 1.0f, lightNorth, overlay, tintNorth);
        }
        if (renderSouth) {
            this.south(vc, pose, south, 1.0f, lightSouth, overlay, tintSouth);
        }
        if (renderWest) {
            this.west(vc, pose, west, 1.0f, lightWest, overlay, tintWest);
        }
        if (renderEast) {
            this.east(vc, pose, east, 1.0f, lightEast, overlay, tintEast);
        }
    }

    private void top(VertexConsumer vc, PoseStack pose, TextureAtlasSprite sprite, float y, int light, int overlay, int tint) {
        Matrix4f m = pose.m_85850_().m_252922_();
        Matrix3f n = pose.m_85850_().m_252943_();
        float u0 = sprite.m_118409_();
        float v0 = sprite.m_118411_();
        float u1 = sprite.m_118410_();
        float v1 = sprite.m_118412_();
        float r = (float)(tint >> 16 & 0xFF) / 255.0f * 1.0f;
        float g = (float)(tint >> 8 & 0xFF) / 255.0f * 1.0f;
        float b = (float)(tint & 0xFF) / 255.0f * 1.0f;
        vc.m_252986_(m, 0.0f, y, 1.0f).m_85950_(r, g, b, 1.0f).m_7421_(u0, v1).m_85969_(light).m_86008_(overlay).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        vc.m_252986_(m, 1.0f, y, 1.0f).m_85950_(r, g, b, 1.0f).m_7421_(u1, v1).m_85969_(light).m_86008_(overlay).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        vc.m_252986_(m, 1.0f, y, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(u1, v0).m_85969_(light).m_86008_(overlay).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        vc.m_252986_(m, 0.0f, y, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(u0, v0).m_85969_(light).m_86008_(overlay).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private void bottom(VertexConsumer vc, PoseStack pose, TextureAtlasSprite sprite, float y, int light, int overlay, int tint) {
        Matrix4f m = pose.m_85850_().m_252922_();
        Matrix3f n = pose.m_85850_().m_252943_();
        float u0 = sprite.m_118409_();
        float v0 = sprite.m_118411_();
        float u1 = sprite.m_118410_();
        float v1 = sprite.m_118412_();
        float r = (float)(tint >> 16 & 0xFF) / 255.0f * 0.5f;
        float g = (float)(tint >> 8 & 0xFF) / 255.0f * 0.5f;
        float b = (float)(tint & 0xFF) / 255.0f * 0.5f;
        vc.m_252986_(m, 0.0f, y, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(u0, v0).m_85969_(light).m_86008_(overlay).m_252939_(n, 0.0f, -1.0f, 0.0f).m_5752_();
        vc.m_252986_(m, 1.0f, y, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(u1, v0).m_85969_(light).m_86008_(overlay).m_252939_(n, 0.0f, -1.0f, 0.0f).m_5752_();
        vc.m_252986_(m, 1.0f, y, 1.0f).m_85950_(r, g, b, 1.0f).m_7421_(u1, v1).m_85969_(light).m_86008_(overlay).m_252939_(n, 0.0f, -1.0f, 0.0f).m_5752_();
        vc.m_252986_(m, 0.0f, y, 1.0f).m_85950_(r, g, b, 1.0f).m_7421_(u0, v1).m_85969_(light).m_86008_(overlay).m_252939_(n, 0.0f, -1.0f, 0.0f).m_5752_();
    }

    private void north(VertexConsumer vc, PoseStack pose, TextureAtlasSprite sprite, float h, int light, int overlay, int tint) {
        Matrix4f m = pose.m_85850_().m_252922_();
        Matrix3f n = pose.m_85850_().m_252943_();
        float u0 = sprite.m_118409_();
        float v0 = sprite.m_118411_();
        float u1 = sprite.m_118410_();
        float v1 = sprite.m_118412_();
        float r = (float)(tint >> 16 & 0xFF) / 255.0f * 0.8f;
        float g = (float)(tint >> 8 & 0xFF) / 255.0f * 0.8f;
        float b = (float)(tint & 0xFF) / 255.0f * 0.8f;
        vc.m_252986_(m, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(u0, v1).m_85969_(light).m_86008_(overlay).m_252939_(n, 0.0f, 0.0f, -1.0f).m_5752_();
        vc.m_252986_(m, 0.0f, h, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(u0, v0).m_85969_(light).m_86008_(overlay).m_252939_(n, 0.0f, 0.0f, -1.0f).m_5752_();
        vc.m_252986_(m, 1.0f, h, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(u1, v0).m_85969_(light).m_86008_(overlay).m_252939_(n, 0.0f, 0.0f, -1.0f).m_5752_();
        vc.m_252986_(m, 1.0f, 0.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(u1, v1).m_85969_(light).m_86008_(overlay).m_252939_(n, 0.0f, 0.0f, -1.0f).m_5752_();
    }

    private void south(VertexConsumer vc, PoseStack pose, TextureAtlasSprite sprite, float h, int light, int overlay, int tint) {
        Matrix4f m = pose.m_85850_().m_252922_();
        Matrix3f n = pose.m_85850_().m_252943_();
        float u0 = sprite.m_118409_();
        float v0 = sprite.m_118411_();
        float u1 = sprite.m_118410_();
        float v1 = sprite.m_118412_();
        float r = (float)(tint >> 16 & 0xFF) / 255.0f * 0.8f;
        float g = (float)(tint >> 8 & 0xFF) / 255.0f * 0.8f;
        float b = (float)(tint & 0xFF) / 255.0f * 0.8f;
        vc.m_252986_(m, 1.0f, 0.0f, 1.0f).m_85950_(r, g, b, 1.0f).m_7421_(u1, v1).m_85969_(light).m_86008_(overlay).m_252939_(n, 0.0f, 0.0f, 1.0f).m_5752_();
        vc.m_252986_(m, 1.0f, h, 1.0f).m_85950_(r, g, b, 1.0f).m_7421_(u1, v0).m_85969_(light).m_86008_(overlay).m_252939_(n, 0.0f, 0.0f, 1.0f).m_5752_();
        vc.m_252986_(m, 0.0f, h, 1.0f).m_85950_(r, g, b, 1.0f).m_7421_(u0, v0).m_85969_(light).m_86008_(overlay).m_252939_(n, 0.0f, 0.0f, 1.0f).m_5752_();
        vc.m_252986_(m, 0.0f, 0.0f, 1.0f).m_85950_(r, g, b, 1.0f).m_7421_(u0, v1).m_85969_(light).m_86008_(overlay).m_252939_(n, 0.0f, 0.0f, 1.0f).m_5752_();
    }

    private void west(VertexConsumer vc, PoseStack pose, TextureAtlasSprite sprite, float h, int light, int overlay, int tint) {
        Matrix4f m = pose.m_85850_().m_252922_();
        Matrix3f n = pose.m_85850_().m_252943_();
        float u0 = sprite.m_118409_();
        float v0 = sprite.m_118411_();
        float u1 = sprite.m_118410_();
        float v1 = sprite.m_118412_();
        float r = (float)(tint >> 16 & 0xFF) / 255.0f * 0.6f;
        float g = (float)(tint >> 8 & 0xFF) / 255.0f * 0.6f;
        float b = (float)(tint & 0xFF) / 255.0f * 0.6f;
        vc.m_252986_(m, 0.0f, 0.0f, 1.0f).m_85950_(r, g, b, 1.0f).m_7421_(u0, v1).m_85969_(light).m_86008_(overlay).m_252939_(n, -1.0f, 0.0f, 0.0f).m_5752_();
        vc.m_252986_(m, 0.0f, h, 1.0f).m_85950_(r, g, b, 1.0f).m_7421_(u0, v0).m_85969_(light).m_86008_(overlay).m_252939_(n, -1.0f, 0.0f, 0.0f).m_5752_();
        vc.m_252986_(m, 0.0f, h, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(u1, v0).m_85969_(light).m_86008_(overlay).m_252939_(n, -1.0f, 0.0f, 0.0f).m_5752_();
        vc.m_252986_(m, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(u1, v1).m_85969_(light).m_86008_(overlay).m_252939_(n, -1.0f, 0.0f, 0.0f).m_5752_();
    }

    private void east(VertexConsumer vc, PoseStack pose, TextureAtlasSprite sprite, float h, int light, int overlay, int tint) {
        Matrix4f m = pose.m_85850_().m_252922_();
        Matrix3f n = pose.m_85850_().m_252943_();
        float u0 = sprite.m_118409_();
        float v0 = sprite.m_118411_();
        float u1 = sprite.m_118410_();
        float v1 = sprite.m_118412_();
        float r = (float)(tint >> 16 & 0xFF) / 255.0f * 0.6f;
        float g = (float)(tint >> 8 & 0xFF) / 255.0f * 0.6f;
        float b = (float)(tint & 0xFF) / 255.0f * 0.6f;
        vc.m_252986_(m, 1.0f, 0.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(u1, v1).m_85969_(light).m_86008_(overlay).m_252939_(n, 1.0f, 0.0f, 0.0f).m_5752_();
        vc.m_252986_(m, 1.0f, h, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(u1, v0).m_85969_(light).m_86008_(overlay).m_252939_(n, 1.0f, 0.0f, 0.0f).m_5752_();
        vc.m_252986_(m, 1.0f, h, 1.0f).m_85950_(r, g, b, 1.0f).m_7421_(u0, v0).m_85969_(light).m_86008_(overlay).m_252939_(n, 1.0f, 0.0f, 0.0f).m_5752_();
        vc.m_252986_(m, 1.0f, 0.0f, 1.0f).m_85950_(r, g, b, 1.0f).m_7421_(u0, v1).m_85969_(light).m_86008_(overlay).m_252939_(n, 1.0f, 0.0f, 0.0f).m_5752_();
    }

    public boolean shouldRenderOffScreen(ParkourBlockEntity blockEntity) {
        return true;
    }
}

