/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.pakourblocks.movement;

import de.sarocesch.pakourblocks.movement.MovementStep;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class MovementSequence {
    private List<MovementStep> steps = new ArrayList<MovementStep>();
    private boolean loop = true;

    public MovementSequence() {
    }

    public MovementSequence(boolean addDefaultStep) {
        if (addDefaultStep) {
            this.steps.add(new MovementStep());
        }
    }

    public List<MovementStep> getSteps() {
        return this.steps;
    }

    public void setSteps(List<MovementStep> steps) {
        this.steps = new ArrayList<MovementStep>(steps);
    }

    public void addStep(MovementStep step) {
        this.steps.add(step);
    }

    public void removeStep(int index) {
        if (index >= 0 && index < this.steps.size()) {
            this.steps.remove(index);
        }
    }

    public boolean isLoop() {
        return this.loop;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        ListTag stepsList = new ListTag();
        for (MovementStep step : this.steps) {
            stepsList.add((Object)step.save());
        }
        tag.m_128365_("Steps", (Tag)stepsList);
        tag.m_128379_("Loop", this.loop);
        return tag;
    }

    public static MovementSequence load(CompoundTag tag) {
        MovementSequence sequence = new MovementSequence();
        sequence.steps.clear();
        if (tag.m_128441_("Steps")) {
            ListTag stepsList = tag.m_128437_("Steps", 10);
            for (int i = 0; i < stepsList.size(); ++i) {
                CompoundTag stepTag = stepsList.m_128728_(i);
                sequence.steps.add(MovementStep.load(stepTag));
            }
        }
        sequence.loop = tag.m_128471_("Loop");
        return sequence;
    }
}

