/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.pakourblocks.network;

import de.sarocesch.pakourblocks.block.ParkourBlock;
import de.sarocesch.pakourblocks.block.ParkourBlockEntity;
import de.sarocesch.pakourblocks.config.ModConfig;
import de.sarocesch.pakourblocks.network.NetworkHandler;
import de.sarocesch.pakourblocks.network.PacketSyncBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketSetBlockEffects {
    private static final Logger LOGGER = LoggerFactory.getLogger(PacketSetBlockEffects.class);
    private final BlockPos pos;
    private final List<MobEffectInstance> effects;

    public PacketSetBlockEffects(BlockPos pos, List<MobEffectInstance> effects) {
        this.pos = pos;
        this.effects = effects;
    }

    public static void encode(PacketSetBlockEffects msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.pos);
        buf.writeInt(msg.effects.size());
        for (MobEffectInstance effect : msg.effects) {
            ResourceLocation effectId = BuiltInRegistries.f_256974_.m_7981_((Object)effect.m_19544_());
            buf.m_130085_(effectId);
            buf.writeInt(effect.m_19564_());
            buf.writeInt(effect.m_19557_());
        }
    }

    public static PacketSetBlockEffects decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        int size = buf.readInt();
        ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
        for (int i = 0; i < size; ++i) {
            ResourceLocation effectId = buf.m_130281_();
            MobEffect effect = (MobEffect)BuiltInRegistries.f_256974_.m_7745_(effectId);
            int amplifier = buf.readInt();
            int duration = buf.readInt();
            effects.add(new MobEffectInstance(effect, duration, amplifier));
        }
        return new PacketSetBlockEffects(pos, effects);
    }

    public static void handle(PacketSetBlockEffects msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BlockState state;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (state = player.m_9236_().m_8055_(msg.pos)).m_60734_() instanceof ParkourBlock) {
                BlockEntity blockEntity;
                if (ModConfig.debugMode) {
                    LOGGER.info("Setting parkour block effects: {} effects", (Object)msg.effects.size());
                }
                if ((blockEntity = player.m_9236_().m_7702_(msg.pos)) instanceof ParkourBlockEntity) {
                    ParkourBlockEntity parkourBlockEntity = (ParkourBlockEntity)blockEntity;
                    parkourBlockEntity.setEffects(msg.effects);
                    parkourBlockEntity.m_6596_();
                    player.m_9236_().m_7260_(msg.pos, state, state, 3);
                    NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> player.m_9236_().m_46745_(msg.pos)), (Object)new PacketSyncBlockEntity(msg.pos, msg.effects));
                    player.m_213846_((Component)Component.m_237113_((String)("Effects updated: " + msg.effects.size() + " effects set")));
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

