/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.pakourblocks.network;

import de.sarocesch.pakourblocks.config.ModConfig;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketSetBlockMode {
    private static final Logger LOGGER = LoggerFactory.getLogger(PacketSetBlockMode.class);
    private final BlockPos pos;
    private final String mode;

    public PacketSetBlockMode(BlockPos pos, String mode) {
        this.pos = pos;
        this.mode = mode;
    }

    public static void encode(PacketSetBlockMode msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.pos);
        buf.m_130070_(msg.mode);
    }

    public static PacketSetBlockMode decode(FriendlyByteBuf buf) {
        return new PacketSetBlockMode(buf.m_130135_(), buf.m_130277_());
    }

    public static void handle(PacketSetBlockMode msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && ModConfig.debugMode) {
                LOGGER.info("PacketSetBlockMode is deprecated and no longer used");
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

