/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.pakourblocks.network;

import de.sarocesch.pakourblocks.block.ParkourBlockEntity;
import de.sarocesch.pakourblocks.config.ModConfig;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketSetPaused {
    private static final Logger LOGGER = LoggerFactory.getLogger(PacketSetPaused.class);
    private final BlockPos pos;
    private final boolean paused;

    public PacketSetPaused(BlockPos pos, boolean paused) {
        this.pos = pos;
        this.paused = paused;
    }

    public static void encode(PacketSetPaused msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.pos);
        buf.writeBoolean(msg.paused);
    }

    public static PacketSetPaused decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        boolean paused = buf.readBoolean();
        return new PacketSetPaused(pos, paused);
    }

    public static void handle(PacketSetPaused msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BlockEntity blockEntity;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (blockEntity = player.m_9236_().m_7702_(msg.pos)) instanceof ParkourBlockEntity) {
                ParkourBlockEntity parkourBlockEntity = (ParkourBlockEntity)blockEntity;
                if (ModConfig.debugMode) {
                    LOGGER.info("Setting paused state to {} for block at {}", (Object)msg.paused, (Object)msg.pos);
                }
                parkourBlockEntity.setPaused(msg.paused);
                parkourBlockEntity.m_6596_();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

