/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.pakourblocks.network;

import de.sarocesch.pakourblocks.block.ParkourBlockEntity;
import de.sarocesch.pakourblocks.config.ModConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketSyncBlockEntity {
    private static final Logger LOGGER = LoggerFactory.getLogger(PacketSyncBlockEntity.class);
    private final BlockPos pos;
    private final List<MobEffectInstance> effects;

    public PacketSyncBlockEntity(BlockPos pos, List<MobEffectInstance> effects) {
        this.pos = pos;
        this.effects = effects;
    }

    public static void encode(PacketSyncBlockEntity msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.pos);
        buf.writeInt(msg.effects.size());
        for (MobEffectInstance effect : msg.effects) {
            ResourceLocation effectId = BuiltInRegistries.f_256974_.m_7981_((Object)effect.m_19544_());
            buf.m_130085_(effectId);
            buf.writeInt(effect.m_19564_());
            buf.writeInt(effect.m_19557_());
        }
    }

    public static PacketSyncBlockEntity decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        int size = buf.readInt();
        ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
        for (int i = 0; i < size; ++i) {
            ResourceLocation effectId = buf.m_130281_();
            MobEffect effect = (MobEffect)BuiltInRegistries.f_256974_.m_7745_(effectId);
            int amplifier = buf.readInt();
            int duration = buf.readInt();
            effects.add(new MobEffectInstance(effect, duration, amplifier));
        }
        return new PacketSyncBlockEntity(pos, effects);
    }

    public static void handle(PacketSyncBlockEntity msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> PacketSyncBlockEntity.handleClient(msg)));
        ctx.get().setPacketHandled(true);
    }

    private static void handleClient(PacketSyncBlockEntity msg) {
        BlockEntity blockEntity;
        if (Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        if (ModConfig.debugMode) {
            LOGGER.info("Received sync packet for BlockEntity at {} with {} effects", (Object)msg.pos, (Object)msg.effects.size());
        }
        if ((blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(msg.pos)) instanceof ParkourBlockEntity) {
            ParkourBlockEntity parkourBlockEntity = (ParkourBlockEntity)blockEntity;
            parkourBlockEntity.setEffects(msg.effects);
            if (ModConfig.debugMode) {
                LOGGER.info("Updated client-side BlockEntity with {} effects", (Object)msg.effects.size());
                for (MobEffectInstance effect : msg.effects) {
                    LOGGER.info("  - Effect: {}, Level: {}, Duration: {} ticks", new Object[]{effect.m_19544_().m_19481_(), effect.m_19564_(), effect.m_19557_()});
                }
            }
        } else if (ModConfig.debugMode) {
            LOGGER.warn("No ParkourBlockEntity found at {} on client", (Object)msg.pos);
        }
    }
}

