/*
 * Decompiled with CFR 0.152.
 */
package net.nibs.mapleforest.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ModelTurkeyBody
extends EntityModel<LivingEntityRenderState> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"mapleforest", (String)"model_turkey_body"), "main");
    public final ModelPart Body;
    public final ModelPart Head;
    public final ModelPart Wings;
    public final ModelPart RLeg;
    public final ModelPart LLeg;

    public ModelTurkeyBody(ModelPart root) {
        super(root);
        this.Body = root.getChild("Body");
        this.Head = root.getChild("Head");
        this.Wings = root.getChild("Wings");
        this.RLeg = root.getChild("RLeg");
        this.LLeg = root.getChild("LLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 13).addBox(1.0f, 0.0f, -11.0f, 10.0f, 8.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(32, 14).addBox(-1.0f, -7.0f, 0.0f, 14.0f, 10.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-6.0f, (float)12.0f, (float)7.0f));
        PartDefinition Head = partdefinition.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(14, 0).addBox(-2.0f, -3.0f, -4.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 15).addBox(-1.0f, -2.0f, -3.0f, 2.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-2.0f, -5.0f, -2.0f, 4.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)14.0f, (float)-4.0f));
        PartDefinition Wings = partdefinition.addOrReplaceChild("Wings", CubeListBuilder.create().texOffs(48, 0).addBox(5.0f, -10.0f, -2.0f, 1.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(48, 0).addBox(-6.0f, -10.0f, -2.0f, 1.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition RLeg = partdefinition.addOrReplaceChild("RLeg", CubeListBuilder.create().texOffs(26, 0).addBox(-2.0f, -1.0f, -2.0f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)20.0f, (float)1.0f));
        PartDefinition LLeg = partdefinition.addOrReplaceChild("LLeg", CubeListBuilder.create().texOffs(26, 0).addBox(-1.0f, -1.0f, -2.0f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)20.0f, (float)1.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(LivingEntityRenderState state) {
        float limbSwing = state.walkAnimationPos;
        float limbSwingAmount = state.walkAnimationSpeed;
        float ageInTicks = state.ageInTicks;
        float netHeadYaw = state.yRot;
        float headPitch = state.xRot;
        this.LLeg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.Head.yRot = netHeadYaw / 57.295776f;
        this.Head.xRot = headPitch / 57.295776f;
        this.RLeg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
    }
}

