/*
 * Decompiled with CFR 0.152.
 */
package net.nibs.mapleforest.init;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.nibs.mapleforest.entity.CoursedScarecrowEntity;
import net.nibs.mapleforest.entity.TurkeyEntity;

@EventBusSubscriber
public class MapleforestModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"mapleforest");
    public static final DeferredHolder<EntityType<?>, EntityType<TurkeyEntity>> TURKEY = MapleforestModEntities.register("turkey", EntityType.Builder.of(TurkeyEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<CoursedScarecrowEntity>> COURSED_SCARECROW = MapleforestModEntities.register("coursed_scarecrow", EntityType.Builder.of(CoursedScarecrowEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(512).setUpdateInterval(3).fireImmune().sized(0.6f, 1.8f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mapleforest", (String)registryname))));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        TurkeyEntity.init(event);
        CoursedScarecrowEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)TURKEY.get(), TurkeyEntity.createAttributes().build());
        event.put((EntityType)COURSED_SCARECROW.get(), CoursedScarecrowEntity.createAttributes().build());
    }
}

