/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.pickaxetrims.client;

import dev.foxgirl.pickaxetrims.shared.PickaxeTrim;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1091;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PickaxeTrimModels {
    private static final class_1091[] MODEL_IDS = new class_1091[PickaxeTrim.PickaxeType.COUNT * PickaxeTrim.TrimType.COUNT];

    private static int calculateIndex(PickaxeTrim.PickaxeType pickaxeType, PickaxeTrim.TrimType trimType) {
        return pickaxeType.ordinal() * PickaxeTrim.TrimType.COUNT + trimType.ordinal();
    }

    @NotNull
    public static class_1091 getModelID(@NotNull PickaxeTrim.PickaxeType pickaxeType, @NotNull PickaxeTrim.TrimType trimType) {
        return MODEL_IDS[PickaxeTrimModels.calculateIndex(pickaxeType, trimType)];
    }

    @Nullable
    public static class_1091 getModelID(@NotNull class_1799 stack) {
        PickaxeTrim.PickaxeType pickaxeType = PickaxeTrim.getPickaxeType(stack);
        if (pickaxeType == null) {
            return null;
        }
        PickaxeTrim.TrimType trimType = PickaxeTrim.getTrimType(stack);
        if (trimType == null) {
            return null;
        }
        return PickaxeTrimModels.getModelID(pickaxeType, trimType);
    }

    @NotNull
    public static List<class_1091> getModelIDs() {
        return Arrays.asList(MODEL_IDS);
    }

    static {
        for (PickaxeTrim.PickaxeType pickaxeType : PickaxeTrim.PickaxeType.VALUES) {
            for (PickaxeTrim.TrimType trimType : PickaxeTrim.TrimType.VALUES) {
                class_1091 modelInventoryID;
                class_2960 baseID = class_2960.method_43902((String)"pickaxetrims", (String)(pickaxeType + "_trimmed_" + trimType));
                PickaxeTrimModels.MODEL_IDS[PickaxeTrimModels.calculateIndex((PickaxeTrim.PickaxeType)pickaxeType, (PickaxeTrim.TrimType)trimType)] = modelInventoryID = new class_1091(baseID, "inventory");
            }
        }
    }
}

