/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.pickaxetrims.shared;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5244;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PickaxeTrim(@NotNull TrimType type) {
    public static final String NBT_KEY = "pickaxetrims_trim_type";
    private static final class_2561 UPGRADE_TEXT = class_2561.method_43471((String)class_156.method_646((String)"item", (class_2960)new class_2960("smithing_template.upgrade"))).method_27692(class_124.field_1080);

    @NotNull
    public TrimType trimType() {
        return this.type();
    }

    @Nullable
    public static PickaxeTrim get(@NotNull class_1799 stack) {
        TrimType trimType;
        if (stack.method_7985() && (trimType = TrimType.BY_NAME.get(stack.method_7969().method_10558(NBT_KEY))) != null) {
            return new PickaxeTrim(trimType);
        }
        return null;
    }

    @NotNull
    public static class_1799 set(@NotNull class_1799 stack, @NotNull PickaxeTrim trim) {
        return PickaxeTrim.set(stack, trim.trimType());
    }

    @NotNull
    public static class_1799 set(@NotNull class_1799 stack, @NotNull TrimType trimType) {
        stack.method_7948().method_10582(NBT_KEY, trimType.toString());
        return stack;
    }

    @Nullable
    public static PickaxeType getPickaxeType(@Nullable class_1799 stack) {
        if (stack == null) {
            return null;
        }
        return PickaxeType.from(stack.method_7909());
    }

    @Nullable
    public static TrimType getTrimType(@Nullable class_1799 stack) {
        PickaxeTrim trim;
        if (stack != null && (trim = PickaxeTrim.get(stack)) != null) {
            return trim.trimType();
        }
        return null;
    }

    public static boolean isOfTrimType(@Nullable class_1799 stack, @NotNull TrimType trimType) {
        return PickaxeTrim.getTrimType(stack) == trimType;
    }

    public static void appendTooltip(class_1799 stack, List<class_2561> tooltip) {
        TrimType trimType = PickaxeTrim.getTrimType(stack);
        if (trimType != null) {
            tooltip.add(UPGRADE_TEXT);
            tooltip.add((class_2561)class_5244.method_48320().method_10852(trimType.getMaterialText()));
            tooltip.add((class_2561)class_5244.method_48320().method_10852(trimType.getDescriptionText()));
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum TrimType {
        CRYING_OBSIDIAN{

            @NotNull
            public String toString() {
                return "crying_obsidian";
            }

            @Override
            @NotNull
            public class_1792 getItem() {
                return class_1802.field_22421;
            }

            @Override
            @NotNull
            public class_124 getColor() {
                return class_124.field_1064;
            }
        }
        ,
        LAPIS_LAZULI{

            @NotNull
            public String toString() {
                return "lapis_lazuli";
            }

            @Override
            @NotNull
            public class_1792 getItem() {
                return class_1802.field_8759;
            }

            @Override
            @NotNull
            public class_124 getColor() {
                return class_124.field_1078;
            }
        }
        ,
        EMERALD{

            @NotNull
            public String toString() {
                return "emerald";
            }

            @Override
            @NotNull
            public class_1792 getItem() {
                return class_1802.field_8687;
            }

            @Override
            @NotNull
            public class_124 getColor() {
                return class_124.field_1060;
            }
        }
        ,
        QUARTZ{

            @NotNull
            public String toString() {
                return "quartz";
            }

            @Override
            @NotNull
            public class_1792 getItem() {
                return class_1802.field_8155;
            }

            @Override
            @NotNull
            public class_124 getColor() {
                return class_124.field_1068;
            }
        }
        ,
        REDSTONE{

            @NotNull
            public String toString() {
                return "redstone";
            }

            @Override
            @NotNull
            public class_1792 getItem() {
                return class_1802.field_8725;
            }

            @Override
            @NotNull
            public class_124 getColor() {
                return class_124.field_1061;
            }
        }
        ,
        COPPER{

            @NotNull
            public String toString() {
                return "copper";
            }

            @Override
            @NotNull
            public class_1792 getItem() {
                return class_1802.field_27022;
            }

            @Override
            @NotNull
            public class_124 getColor() {
                return class_124.field_1065;
            }
        };

        @NotNull
        public static final List<TrimType> VALUES;
        public static final int COUNT;
        @NotNull
        private static final Map<String, TrimType> BY_NAME;

        @Nullable
        public static TrimType parse(@Nullable String name) {
            return BY_NAME.get(name);
        }

        @Nullable
        public static TrimType from(@NotNull class_1792 item) {
            if (item == class_1802.field_22421) {
                return CRYING_OBSIDIAN;
            }
            if (item == class_1802.field_8759) {
                return LAPIS_LAZULI;
            }
            if (item == class_1802.field_8687) {
                return EMERALD;
            }
            if (item == class_1802.field_8155) {
                return QUARTZ;
            }
            if (item == class_1802.field_8725) {
                return REDSTONE;
            }
            if (item == class_1802.field_27022) {
                return COPPER;
            }
            return null;
        }

        @NotNull
        public abstract class_1792 getItem();

        @NotNull
        public abstract class_124 getColor();

        @NotNull
        public class_2561 getMaterialText() {
            return class_2561.method_43471((String)("pickaxetrims.material." + this)).method_27692(this.getColor());
        }

        @NotNull
        public class_2561 getDescriptionText() {
            return class_2561.method_43471((String)("pickaxetrims.description." + this)).method_27692(this.getColor());
        }

        static {
            VALUES = ImmutableList.copyOf((Object[])TrimType.values());
            COUNT = VALUES.size();
            BY_NAME = (Map)class_156.method_654(new HashMap(), map -> {
                for (TrimType type : VALUES) {
                    map.put(type.toString(), type);
                }
            });
        }
    }

    public static enum PickaxeType {
        NETHERITE,
        DIAMOND,
        GOLD,
        IRON;

        @NotNull
        public static final List<PickaxeType> VALUES;
        public static final int COUNT;

        @Nullable
        private static PickaxeType from(@NotNull class_1792 item) {
            if (item == class_1802.field_22024) {
                return NETHERITE;
            }
            if (item == class_1802.field_8377) {
                return DIAMOND;
            }
            if (item == class_1802.field_8335) {
                return GOLD;
            }
            if (item == class_1802.field_8403) {
                return IRON;
            }
            return null;
        }

        @NotNull
        public class_1792 getItem() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case NETHERITE -> class_1802.field_22024;
                case DIAMOND -> class_1802.field_8377;
                case GOLD -> class_1802.field_8335;
                case IRON -> class_1802.field_8403;
            };
        }

        @NotNull
        public String toString() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case NETHERITE -> "netherite_pickaxe";
                case DIAMOND -> "diamond_pickaxe";
                case GOLD -> "gold_pickaxe";
                case IRON -> "iron_pickaxe";
            };
        }

        static {
            VALUES = ImmutableList.copyOf((Object[])PickaxeType.values());
            COUNT = VALUES.size();
        }
    }
}

