/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.pickaxetrims.shared.effect;

import dev.foxgirl.pickaxetrims.shared.OreDetectUtil;
import dev.foxgirl.pickaxetrims.shared.PickaxeTrimsImpl;
import dev.foxgirl.pickaxetrims.shared.effect.AbstractEffect;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public final class RedstoneVeinMineEffect
extends AbstractEffect {
    private final Queue<Runnable> pendingTasks = new ArrayDeque<Runnable>();

    private void findPositions(class_2338 pos, class_2248 block, class_1937 level, class_3222 player, List<class_2338> positions, int depth) {
        if (depth-- < 0) {
            return;
        }
        if (block != level.method_8320(pos).method_26204()) {
            return;
        }
        if (!positions.contains(pos)) {
            positions.add(pos);
            this.findPositions(pos.method_10095(), block, level, player, positions, depth);
            this.findPositions(pos.method_10072(), block, level, player, positions, depth);
            this.findPositions(pos.method_10078(), block, level, player, positions, depth);
            this.findPositions(pos.method_10067(), block, level, player, positions, depth);
            this.findPositions(pos.method_10084(), block, level, player, positions, depth);
            this.findPositions(pos.method_10074(), block, level, player, positions, depth);
        }
    }

    private void sortPositions(class_2338 pos, List<class_2338> positions) {
        positions.sort((a, b) -> {
            double aDistance = a.method_10262((class_2382)pos);
            double bDistance = b.method_10262((class_2382)pos);
            return Double.compare(aDistance, bDistance);
        });
    }

    @Override
    public void onTickEnd(@NotNull MinecraftServer server) {
        Runnable task = this.pendingTasks.poll();
        if (task != null) {
            task.run();
        }
    }

    @Override
    public void onBlockBreak(@NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2680 state, @NotNull class_3222 player) {
        class_2248 block = state.method_26204();
        if (OreDetectUtil.isOreBlock(block)) {
            ArrayList<class_2338> positions = new ArrayList<class_2338>();
            this.findPositions(pos, block, level, player, positions, PickaxeTrimsImpl.getInstance().config.redstoneVeinMineDepth);
            this.sortPositions(pos, positions);
            positions.stream().map(it -> () -> level.method_8651(it, true, (class_1297)player)).forEach(this.pendingTasks::add);
        }
    }
}

