/*
 * Decompiled with CFR 0.152.
 */
package com.github.smallinger.coppergolemlegacy.block;

import com.github.smallinger.coppergolemlegacy.CopperGolemLegacy;
import com.github.smallinger.coppergolemlegacy.ModSounds;
import com.github.smallinger.coppergolemlegacy.block.entity.CopperChestBlockEntity;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CopperChestBlock
extends ChestBlock {
    private static final Map<Block, Supplier<Block>> COPPER_TO_COPPER_CHEST_MAPPING = Map.of(Blocks.COPPER_BLOCK, () -> (Block)CopperGolemLegacy.COPPER_CHEST.get(), Blocks.EXPOSED_COPPER, () -> (Block)CopperGolemLegacy.EXPOSED_COPPER_CHEST.get(), Blocks.WEATHERED_COPPER, () -> (Block)CopperGolemLegacy.WEATHERED_COPPER_CHEST.get(), Blocks.OXIDIZED_COPPER, () -> (Block)CopperGolemLegacy.OXIDIZED_COPPER_CHEST.get(), Blocks.WAXED_COPPER_BLOCK, () -> (Block)CopperGolemLegacy.COPPER_CHEST.get(), Blocks.WAXED_EXPOSED_COPPER, () -> (Block)CopperGolemLegacy.EXPOSED_COPPER_CHEST.get(), Blocks.WAXED_WEATHERED_COPPER, () -> (Block)CopperGolemLegacy.WEATHERED_COPPER_CHEST.get(), Blocks.WAXED_OXIDIZED_COPPER, () -> (Block)CopperGolemLegacy.OXIDIZED_COPPER_CHEST.get());
    protected final WeatheringCopper.WeatherState weatherState;
    private final SoundEvent openSound;
    private final SoundEvent closeSound;

    public CopperChestBlock(WeatheringCopper.WeatherState weatherState, BlockBehaviour.Properties properties) {
        super(properties, () -> (BlockEntityType)CopperGolemLegacy.COPPER_CHEST_BLOCK_ENTITY.get());
        this.weatherState = weatherState;
        this.openSound = (SoundEvent)ModSounds.COPPER_CHEST_OPEN.get();
        this.closeSound = (SoundEvent)ModSounds.COPPER_CHEST_CLOSE.get();
    }

    public MapCodec<? extends ChestBlock> codec() {
        return null;
    }

    public WeatheringCopper.WeatherState getState() {
        return this.weatherState;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CopperChestBlockEntity(pos, state);
    }

    public static BlockState getFromCopperBlock(Block block, Direction direction, Level level, BlockPos pos) {
        Block chestBlock = COPPER_TO_COPPER_CHEST_MAPPING.getOrDefault(block, () -> (Block)CopperGolemLegacy.COPPER_CHEST.get()).get();
        return (BlockState)chestBlock.defaultBlockState().setValue((Property)FACING, (Comparable)direction);
    }

    public static Optional<Block> getUnwaxedBlock(Block block) {
        if (block == CopperGolemLegacy.WAXED_COPPER_CHEST.get()) {
            return Optional.of((Block)CopperGolemLegacy.COPPER_CHEST.get());
        }
        if (block == CopperGolemLegacy.WAXED_EXPOSED_COPPER_CHEST.get()) {
            return Optional.of((Block)CopperGolemLegacy.EXPOSED_COPPER_CHEST.get());
        }
        if (block == CopperGolemLegacy.WAXED_WEATHERED_COPPER_CHEST.get()) {
            return Optional.of((Block)CopperGolemLegacy.WEATHERED_COPPER_CHEST.get());
        }
        if (block == CopperGolemLegacy.WAXED_OXIDIZED_COPPER_CHEST.get()) {
            return Optional.of((Block)CopperGolemLegacy.OXIDIZED_COPPER_CHEST.get());
        }
        return Optional.empty();
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is(ItemTags.AXES)) {
            CopperChestBlockEntity chestEntity;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof CopperChestBlockEntity && (chestEntity = (CopperChestBlockEntity)blockEntity).isChestOpen()) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            Optional<Block> unwaxedBlock = CopperChestBlock.getUnwaxedBlock(state.getBlock());
            if (unwaxedBlock.isPresent()) {
                ChestType chestType = (ChestType)state.getValue((Property)TYPE);
                Block newBlock = unwaxedBlock.get();
                if (chestType != ChestType.SINGLE) {
                    Direction connectedDir = ChestBlock.getConnectedDirection((BlockState)state);
                    BlockPos connectedPos = pos.relative(connectedDir);
                    BlockState connectedState = level.getBlockState(connectedPos);
                    if (connectedState.getBlock() == state.getBlock()) {
                        level.playSound(player, pos, SoundEvents.AXE_WAX_OFF, SoundSource.BLOCKS, 1.0f, 1.0f);
                        level.levelEvent(player, 3004, pos, 0);
                        level.playSound(player, connectedPos, SoundEvents.AXE_WAX_OFF, SoundSource.BLOCKS, 1.0f, 1.0f);
                        level.levelEvent(player, 3004, connectedPos, 0);
                    } else {
                        level.playSound(player, pos, SoundEvents.AXE_WAX_OFF, SoundSource.BLOCKS, 1.0f, 1.0f);
                        level.levelEvent(player, 3004, pos, 0);
                    }
                } else {
                    level.playSound(player, pos, SoundEvents.AXE_WAX_OFF, SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.levelEvent(player, 3004, pos, 0);
                }
                if (!level.isClientSide) {
                    NonNullList<ItemStack> currentItems = CopperChestBlock.copyInventoryAndClear(level, pos);
                    NonNullList<ItemStack> connectedItems = NonNullList.create();
                    BlockState newState = newBlock.withPropertiesOf(state);
                    if (chestType != ChestType.SINGLE) {
                        Direction connectedDir = ChestBlock.getConnectedDirection((BlockState)state);
                        BlockPos connectedPos = pos.relative(connectedDir);
                        BlockState connectedState = level.getBlockState(connectedPos);
                        if (connectedState.getBlock() == state.getBlock()) {
                            BlockState connectedNewState = newBlock.withPropertiesOf(connectedState);
                            connectedItems = CopperChestBlock.copyInventoryAndClear(level, connectedPos);
                            level.setBlock(pos, newState, 2);
                            level.setBlock(connectedPos, connectedNewState, 2);
                            level.blockUpdated(pos, newBlock);
                            level.blockUpdated(connectedPos, newBlock);
                            CopperChestBlock.restoreInventory(level, pos, currentItems);
                            CopperChestBlock.restoreInventory(level, connectedPos, connectedItems);
                        } else {
                            level.setBlockAndUpdate(pos, newState);
                            CopperChestBlock.restoreInventory(level, pos, currentItems);
                        }
                    } else {
                        level.setBlockAndUpdate(pos, newState);
                        CopperChestBlock.restoreInventory(level, pos, currentItems);
                    }
                    stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                }
                return ItemInteractionResult.SUCCESS;
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected static NonNullList<ItemStack> copyInventoryAndClear(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof Container) {
            Container container = (Container)blockEntity;
            NonNullList items = NonNullList.withSize((int)container.getContainerSize(), (Object)ItemStack.EMPTY);
            for (int i = 0; i < container.getContainerSize(); ++i) {
                items.set(i, (Object)container.getItem(i).copy());
            }
            container.clearContent();
            if (blockEntity instanceof CopperChestBlockEntity) {
                CopperChestBlockEntity chestEntity = (CopperChestBlockEntity)blockEntity;
                chestEntity.setChanged();
            }
            return items;
        }
        return NonNullList.create();
    }

    protected static void restoreInventory(Level level, BlockPos pos, NonNullList<ItemStack> items) {
        if (items.isEmpty()) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof Container) {
            Container container = (Container)blockEntity;
            for (int i = 0; i < Math.min(container.getContainerSize(), items.size()); ++i) {
                container.setItem(i, (ItemStack)items.get(i));
            }
            if (blockEntity instanceof CopperChestBlockEntity) {
                CopperChestBlockEntity chestEntity = (CopperChestBlockEntity)blockEntity;
                chestEntity.setChanged();
            }
        }
    }
}

