/*
 * Decompiled with CFR 0.152.
 */
package com.github.smallinger.coppergolemlegacy.block;

import com.github.smallinger.coppergolemlegacy.CopperGolemLegacy;
import com.github.smallinger.coppergolemlegacy.block.CopperChestBlock;
import com.github.smallinger.coppergolemlegacy.block.entity.CopperChestBlockEntity;
import com.github.smallinger.coppergolemlegacy.util.WeatheringHelper;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class WeatheringCopperChestBlock
extends CopperChestBlock
implements WeatheringCopper {
    public WeatheringCopperChestBlock(WeatheringCopper.WeatherState weatheringState, BlockBehaviour.Properties properties) {
        super(weatheringState, properties);
    }

    public MapCodec<? extends WeatheringCopperChestBlock> codec() {
        return null;
    }

    public static Optional<Block> getNextBlock(Block block) {
        if (block == CopperGolemLegacy.COPPER_CHEST.get()) {
            return Optional.of((Block)CopperGolemLegacy.EXPOSED_COPPER_CHEST.get());
        }
        if (block == CopperGolemLegacy.EXPOSED_COPPER_CHEST.get()) {
            return Optional.of((Block)CopperGolemLegacy.WEATHERED_COPPER_CHEST.get());
        }
        if (block == CopperGolemLegacy.WEATHERED_COPPER_CHEST.get()) {
            return Optional.of((Block)CopperGolemLegacy.OXIDIZED_COPPER_CHEST.get());
        }
        return WeatheringCopper.getNext((Block)block);
    }

    public static Optional<Block> getPreviousBlock(Block block) {
        if (block == CopperGolemLegacy.OXIDIZED_COPPER_CHEST.get()) {
            return Optional.of((Block)CopperGolemLegacy.WEATHERED_COPPER_CHEST.get());
        }
        if (block == CopperGolemLegacy.WEATHERED_COPPER_CHEST.get()) {
            return Optional.of((Block)CopperGolemLegacy.EXPOSED_COPPER_CHEST.get());
        }
        if (block == CopperGolemLegacy.EXPOSED_COPPER_CHEST.get()) {
            return Optional.of((Block)CopperGolemLegacy.COPPER_CHEST.get());
        }
        return Optional.empty();
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is(ItemTags.AXES)) {
            CopperChestBlockEntity chestEntity;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof CopperChestBlockEntity && (chestEntity = (CopperChestBlockEntity)blockEntity).isChestOpen()) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            Optional<Block> previousBlock = WeatheringCopperChestBlock.getPreviousBlock(state.getBlock());
            if (previousBlock.isPresent()) {
                ChestType chestType = (ChestType)state.getValue((Property)TYPE);
                Block newBlock = previousBlock.get();
                if (chestType != ChestType.SINGLE) {
                    Direction connectedDir = ChestBlock.getConnectedDirection((BlockState)state);
                    BlockPos connectedPos = pos.relative(connectedDir);
                    BlockState connectedState = level.getBlockState(connectedPos);
                    if (connectedState.getBlock() == state.getBlock()) {
                        level.playSound(player, pos, SoundEvents.AXE_SCRAPE, SoundSource.BLOCKS, 1.0f, 1.0f);
                        level.levelEvent(player, 3005, pos, 0);
                        level.playSound(player, connectedPos, SoundEvents.AXE_SCRAPE, SoundSource.BLOCKS, 1.0f, 1.0f);
                        level.levelEvent(player, 3005, connectedPos, 0);
                    } else {
                        level.playSound(player, pos, SoundEvents.AXE_SCRAPE, SoundSource.BLOCKS, 1.0f, 1.0f);
                        level.levelEvent(player, 3005, pos, 0);
                    }
                } else {
                    level.playSound(player, pos, SoundEvents.AXE_SCRAPE, SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.levelEvent(player, 3005, pos, 0);
                }
                if (!level.isClientSide) {
                    NonNullList<ItemStack> currentItems = WeatheringCopperChestBlock.copyInventoryAndClear(level, pos);
                    NonNullList<ItemStack> connectedItems = NonNullList.create();
                    BlockState newState = newBlock.withPropertiesOf(state);
                    if (chestType != ChestType.SINGLE) {
                        Direction connectedDir = ChestBlock.getConnectedDirection((BlockState)state);
                        BlockPos connectedPos = pos.relative(connectedDir);
                        BlockState connectedState = level.getBlockState(connectedPos);
                        if (connectedState.getBlock() == state.getBlock()) {
                            BlockState connectedNewState = newBlock.withPropertiesOf(connectedState);
                            connectedItems = WeatheringCopperChestBlock.copyInventoryAndClear(level, connectedPos);
                            level.setBlock(pos, newState, 2);
                            level.setBlock(connectedPos, connectedNewState, 2);
                            level.blockUpdated(pos, newBlock);
                            level.blockUpdated(connectedPos, newBlock);
                            WeatheringCopperChestBlock.restoreInventory(level, pos, currentItems);
                            WeatheringCopperChestBlock.restoreInventory(level, connectedPos, connectedItems);
                            stack.hurtAndBreak(2, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                        } else {
                            level.setBlockAndUpdate(pos, newState);
                            WeatheringCopperChestBlock.restoreInventory(level, pos, currentItems);
                            stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                        }
                    } else {
                        level.setBlockAndUpdate(pos, newState);
                        WeatheringCopperChestBlock.restoreInventory(level, pos, currentItems);
                        stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                    }
                }
                return ItemInteractionResult.SUCCESS;
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (stack.is(Items.HONEYCOMB)) {
            CopperChestBlockEntity chestEntity;
            BlockEntity chestType = level.getBlockEntity(pos);
            if (chestType instanceof CopperChestBlockEntity && (chestEntity = (CopperChestBlockEntity)chestType).isChestOpen()) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            Block waxedBlock = null;
            if (this == CopperGolemLegacy.COPPER_CHEST.get()) {
                waxedBlock = (Block)CopperGolemLegacy.WAXED_COPPER_CHEST.get();
            } else if (this == CopperGolemLegacy.EXPOSED_COPPER_CHEST.get()) {
                waxedBlock = (Block)CopperGolemLegacy.WAXED_EXPOSED_COPPER_CHEST.get();
            } else if (this == CopperGolemLegacy.WEATHERED_COPPER_CHEST.get()) {
                waxedBlock = (Block)CopperGolemLegacy.WAXED_WEATHERED_COPPER_CHEST.get();
            } else if (this == CopperGolemLegacy.OXIDIZED_COPPER_CHEST.get()) {
                waxedBlock = (Block)CopperGolemLegacy.WAXED_OXIDIZED_COPPER_CHEST.get();
            }
            if (waxedBlock != null) {
                chestType = (ChestType)state.getValue((Property)TYPE);
                if (chestType != ChestType.SINGLE) {
                    Direction connectedDir = ChestBlock.getConnectedDirection((BlockState)state);
                    BlockPos connectedPos = pos.relative(connectedDir);
                    BlockState connectedState = level.getBlockState(connectedPos);
                    if (connectedState.getBlock() == state.getBlock()) {
                        level.playSound(player, pos, SoundEvents.HONEYCOMB_WAX_ON, SoundSource.BLOCKS, 1.0f, 1.0f);
                        level.levelEvent(player, 3003, pos, 0);
                        level.playSound(player, connectedPos, SoundEvents.HONEYCOMB_WAX_ON, SoundSource.BLOCKS, 1.0f, 1.0f);
                        level.levelEvent(player, 3003, connectedPos, 0);
                    } else {
                        level.playSound(player, pos, SoundEvents.HONEYCOMB_WAX_ON, SoundSource.BLOCKS, 1.0f, 1.0f);
                        level.levelEvent(player, 3003, pos, 0);
                    }
                } else {
                    level.playSound(player, pos, SoundEvents.HONEYCOMB_WAX_ON, SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.levelEvent(player, 3003, pos, 0);
                }
                if (!level.isClientSide) {
                    NonNullList<ItemStack> currentItems = WeatheringCopperChestBlock.copyInventoryAndClear(level, pos);
                    NonNullList<ItemStack> connectedItems = NonNullList.create();
                    BlockState waxedState = waxedBlock.withPropertiesOf(state);
                    if (chestType != ChestType.SINGLE) {
                        Direction connectedDir = ChestBlock.getConnectedDirection((BlockState)state);
                        BlockPos connectedPos = pos.relative(connectedDir);
                        BlockState connectedState = level.getBlockState(connectedPos);
                        if (connectedState.getBlock() == state.getBlock()) {
                            BlockState connectedWaxedState = waxedBlock.withPropertiesOf(connectedState);
                            connectedItems = WeatheringCopperChestBlock.copyInventoryAndClear(level, connectedPos);
                            level.setBlock(pos, waxedState, 2);
                            level.setBlock(connectedPos, connectedWaxedState, 2);
                            level.blockUpdated(pos, waxedBlock);
                            level.blockUpdated(connectedPos, waxedBlock);
                            WeatheringCopperChestBlock.restoreInventory(level, pos, currentItems);
                            WeatheringCopperChestBlock.restoreInventory(level, connectedPos, connectedItems);
                        } else {
                            level.setBlockAndUpdate(pos, waxedState);
                            WeatheringCopperChestBlock.restoreInventory(level, pos, currentItems);
                        }
                    } else {
                        level.setBlockAndUpdate(pos, waxedState);
                        WeatheringCopperChestBlock.restoreInventory(level, pos, currentItems);
                    }
                    stack.consume(1, (LivingEntity)player);
                }
                return ItemInteractionResult.SUCCESS;
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        Direction connectedDir;
        BlockPos otherPos;
        BlockState otherState;
        CopperChestBlockEntity chestEntity;
        ChestType chestType = (ChestType)state.getValue((Property)TYPE);
        if (chestType.equals((Object)ChestType.RIGHT)) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CopperChestBlockEntity && (chestEntity = (CopperChestBlockEntity)blockEntity).isChestOpen()) {
            return;
        }
        Optional<Block> nextBlock = WeatheringCopperChestBlock.getNextBlock(state.getBlock());
        if (!nextBlock.isPresent() || random.nextFloat() >= 0.05688889f) {
            return;
        }
        Block newBlock = nextBlock.get();
        if (chestType != ChestType.SINGLE && (otherState = level.getBlockState(otherPos = pos.relative(connectedDir = ChestBlock.getConnectedDirection((BlockState)state)))).getBlock() == state.getBlock()) {
            CopperChestBlockEntity otherChest;
            BlockEntity blockEntity2 = level.getBlockEntity(otherPos);
            if (blockEntity2 instanceof CopperChestBlockEntity && (otherChest = (CopperChestBlockEntity)blockEntity2).isChestOpen()) {
                return;
            }
            NonNullList<ItemStack> thisItems = WeatheringCopperChestBlock.copyInventoryAndClear((Level)level, pos);
            NonNullList<ItemStack> otherItems = WeatheringCopperChestBlock.copyInventoryAndClear((Level)level, otherPos);
            BlockState newState = newBlock.withPropertiesOf(state);
            BlockState newOtherState = newBlock.withPropertiesOf(otherState);
            level.setBlock(pos, newState, 2);
            level.setBlock(otherPos, newOtherState, 2);
            level.blockUpdated(pos, newBlock);
            level.blockUpdated(otherPos, newBlock);
            WeatheringCopperChestBlock.restoreInventory((Level)level, pos, thisItems);
            WeatheringCopperChestBlock.restoreInventory((Level)level, otherPos, otherItems);
            return;
        }
        NonNullList<ItemStack> currentItems = WeatheringCopperChestBlock.copyInventoryAndClear((Level)level, pos);
        BlockState newState = newBlock.withPropertiesOf(state);
        level.setBlock(pos, newState, 2);
        WeatheringCopperChestBlock.restoreInventory((Level)level, pos, currentItems);
        level.blockUpdated(pos, newBlock);
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return WeatheringHelper.canWeather(state, WeatheringCopperChestBlock::getNextBlock);
    }

    public WeatheringCopper.WeatherState getAge() {
        return this.getState();
    }

    protected static NonNullList<ItemStack> copyInventoryAndClear(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof Container) {
            Container container = (Container)blockEntity;
            NonNullList items = NonNullList.withSize((int)container.getContainerSize(), (Object)ItemStack.EMPTY);
            for (int i = 0; i < container.getContainerSize(); ++i) {
                items.set(i, (Object)container.getItem(i).copy());
            }
            container.clearContent();
            if (blockEntity instanceof CopperChestBlockEntity) {
                CopperChestBlockEntity chestEntity = (CopperChestBlockEntity)blockEntity;
                chestEntity.setChanged();
            }
            return items;
        }
        return NonNullList.create();
    }

    protected static void restoreInventory(Level level, BlockPos pos, NonNullList<ItemStack> items) {
        if (items.isEmpty()) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof Container) {
            Container container = (Container)blockEntity;
            for (int i = 0; i < Math.min(container.getContainerSize(), items.size()); ++i) {
                container.setItem(i, (ItemStack)items.get(i));
            }
            if (blockEntity instanceof CopperChestBlockEntity) {
                CopperChestBlockEntity chestEntity = (CopperChestBlockEntity)blockEntity;
                chestEntity.setChanged();
            }
        }
    }
}

