/*
 * Decompiled with CFR 0.152.
 */
package com.github.smallinger.coppergolemlegacy.client.renderer;

import com.github.smallinger.coppergolemlegacy.CopperGolemLegacy;
import com.github.smallinger.coppergolemlegacy.block.CopperChestBlock;
import com.github.smallinger.coppergolemlegacy.block.WeatheringCopperChestBlock;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;

public class CopperChestRenderer
implements BlockEntityRenderer<ChestBlockEntity> {
    private static final Material COPPER_CHEST_MATERIAL = CopperChestRenderer.chestMaterial("copper");
    private static final Material COPPER_CHEST_LEFT_MATERIAL = CopperChestRenderer.chestMaterial("copper_left");
    private static final Material COPPER_CHEST_RIGHT_MATERIAL = CopperChestRenderer.chestMaterial("copper_right");
    private static final Material EXPOSED_COPPER_CHEST_MATERIAL = CopperChestRenderer.chestMaterial("copper_exposed");
    private static final Material EXPOSED_COPPER_CHEST_LEFT_MATERIAL = CopperChestRenderer.chestMaterial("copper_exposed_left");
    private static final Material EXPOSED_COPPER_CHEST_RIGHT_MATERIAL = CopperChestRenderer.chestMaterial("copper_exposed_right");
    private static final Material WEATHERED_COPPER_CHEST_MATERIAL = CopperChestRenderer.chestMaterial("copper_weathered");
    private static final Material WEATHERED_COPPER_CHEST_LEFT_MATERIAL = CopperChestRenderer.chestMaterial("copper_weathered_left");
    private static final Material WEATHERED_COPPER_CHEST_RIGHT_MATERIAL = CopperChestRenderer.chestMaterial("copper_weathered_right");
    private static final Material OXIDIZED_COPPER_CHEST_MATERIAL = CopperChestRenderer.chestMaterial("copper_oxidized");
    private static final Material OXIDIZED_COPPER_CHEST_LEFT_MATERIAL = CopperChestRenderer.chestMaterial("copper_oxidized_left");
    private static final Material OXIDIZED_COPPER_CHEST_RIGHT_MATERIAL = CopperChestRenderer.chestMaterial("copper_oxidized_right");
    private final ModelPart lid;
    private final ModelPart bottom;
    private final ModelPart lock;
    private final ModelPart doubleLeftLid;
    private final ModelPart doubleLeftBottom;
    private final ModelPart doubleLeftLock;
    private final ModelPart doubleRightLid;
    private final ModelPart doubleRightBottom;
    private final ModelPart doubleRightLock;

    public CopperChestRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart singleChest = context.bakeLayer(ModelLayers.CHEST);
        this.bottom = singleChest.getChild("bottom");
        this.lid = singleChest.getChild("lid");
        this.lock = singleChest.getChild("lock");
        ModelPart doubleChestLeft = context.bakeLayer(ModelLayers.DOUBLE_CHEST_LEFT);
        this.doubleLeftBottom = doubleChestLeft.getChild("bottom");
        this.doubleLeftLid = doubleChestLeft.getChild("lid");
        this.doubleLeftLock = doubleChestLeft.getChild("lock");
        ModelPart doubleChestRight = context.bakeLayer(ModelLayers.DOUBLE_CHEST_RIGHT);
        this.doubleRightBottom = doubleChestRight.getChild("bottom");
        this.doubleRightLid = doubleChestRight.getChild("lid");
        this.doubleRightLock = doubleChestRight.getChild("lock");
    }

    private static Material chestMaterial(String name) {
        return new Material(Sheets.CHEST_SHEET, ResourceLocation.fromNamespaceAndPath((String)"coppergolemlegacy", (String)("entity/chest/" + name)));
    }

    public void render(ChestBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Block block;
        Level level;
        boolean flag;
        BlockState blockstate = blockEntity.getBlockState();
        if (!(blockstate.getBlock() instanceof CopperChestBlock)) {
            blockstate = ((WeatheringCopperChestBlock)((Object)CopperGolemLegacy.COPPER_CHEST.get())).defaultBlockState();
        }
        boolean bl = flag = (level = blockEntity.getLevel()) != null;
        if (blockstate.hasProperty((Property)ChestBlock.FACING) && !flag) {
            blockstate = (BlockState)blockstate.setValue((Property)ChestBlock.FACING, (Comparable)Direction.SOUTH);
        }
        if (!blockstate.hasProperty((Property)ChestBlock.FACING)) {
            blockstate = (BlockState)blockstate.setValue((Property)ChestBlock.FACING, (Comparable)Direction.SOUTH);
        }
        if ((block = blockstate.getBlock()) instanceof CopperChestBlock) {
            CopperChestBlock copperChestBlock = (CopperChestBlock)block;
            poseStack.pushPose();
            float f = ((Direction)blockstate.getValue((Property)ChestBlock.FACING)).toYRot();
            poseStack.translate(0.5f, 0.5f, 0.5f);
            poseStack.mulPose(Axis.YP.rotationDegrees(-f));
            poseStack.translate(-0.5f, -0.5f, -0.5f);
            DoubleBlockCombiner.NeighborCombineResult result = flag ? copperChestBlock.combine(blockstate, level, blockEntity.getBlockPos(), true) : DoubleBlockCombiner.Combiner::acceptNone;
            float openness = ((Float2FloatFunction)result.apply(ChestBlock.opennessCombiner((LidBlockEntity)blockEntity))).get(partialTick);
            openness = 1.0f - openness;
            openness = 1.0f - openness * openness * openness;
            int light = ((Int2IntFunction)result.apply((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).applyAsInt(packedLight);
            ChestType chestType = blockstate.hasProperty((Property)ChestBlock.TYPE) ? (ChestType)blockstate.getValue((Property)ChestBlock.TYPE) : ChestType.SINGLE;
            Material material = this.getMaterial(blockstate, chestType);
            VertexConsumer vertexconsumer = material.buffer(bufferSource, RenderType::entityCutout);
            if (chestType == ChestType.LEFT) {
                this.renderParts(poseStack, vertexconsumer, this.doubleLeftLid, this.doubleLeftLock, this.doubleLeftBottom, openness, light, packedOverlay);
            } else if (chestType == ChestType.RIGHT) {
                this.renderParts(poseStack, vertexconsumer, this.doubleRightLid, this.doubleRightLock, this.doubleRightBottom, openness, light, packedOverlay);
            } else {
                this.renderParts(poseStack, vertexconsumer, this.lid, this.lock, this.bottom, openness, light, packedOverlay);
            }
            poseStack.popPose();
        }
    }

    private void renderParts(PoseStack poseStack, VertexConsumer consumer, ModelPart lid, ModelPart lock, ModelPart bottom, float openness, int light, int overlay) {
        lock.xRot = lid.xRot = -(openness * 1.5707964f);
        lid.render(poseStack, consumer, light, overlay);
        lock.render(poseStack, consumer, light, overlay);
        bottom.render(poseStack, consumer, light, overlay);
    }

    private Material getMaterial(BlockState state, ChestType chestType) {
        Block block = state.getBlock();
        if (block == CopperGolemLegacy.COPPER_CHEST.get() || block == CopperGolemLegacy.WAXED_COPPER_CHEST.get()) {
            return switch (chestType) {
                case ChestType.LEFT -> COPPER_CHEST_LEFT_MATERIAL;
                case ChestType.RIGHT -> COPPER_CHEST_RIGHT_MATERIAL;
                default -> COPPER_CHEST_MATERIAL;
            };
        }
        if (block == CopperGolemLegacy.EXPOSED_COPPER_CHEST.get() || block == CopperGolemLegacy.WAXED_EXPOSED_COPPER_CHEST.get()) {
            return switch (chestType) {
                case ChestType.LEFT -> EXPOSED_COPPER_CHEST_LEFT_MATERIAL;
                case ChestType.RIGHT -> EXPOSED_COPPER_CHEST_RIGHT_MATERIAL;
                default -> EXPOSED_COPPER_CHEST_MATERIAL;
            };
        }
        if (block == CopperGolemLegacy.WEATHERED_COPPER_CHEST.get() || block == CopperGolemLegacy.WAXED_WEATHERED_COPPER_CHEST.get()) {
            return switch (chestType) {
                case ChestType.LEFT -> WEATHERED_COPPER_CHEST_LEFT_MATERIAL;
                case ChestType.RIGHT -> WEATHERED_COPPER_CHEST_RIGHT_MATERIAL;
                default -> WEATHERED_COPPER_CHEST_MATERIAL;
            };
        }
        if (block == CopperGolemLegacy.OXIDIZED_COPPER_CHEST.get() || block == CopperGolemLegacy.WAXED_OXIDIZED_COPPER_CHEST.get()) {
            return switch (chestType) {
                case ChestType.LEFT -> OXIDIZED_COPPER_CHEST_LEFT_MATERIAL;
                case ChestType.RIGHT -> OXIDIZED_COPPER_CHEST_RIGHT_MATERIAL;
                default -> OXIDIZED_COPPER_CHEST_MATERIAL;
            };
        }
        return Sheets.CHEST_LOCATION;
    }
}

