/*
 * Decompiled with CFR 0.152.
 */
package com.github.smallinger.coppergolemlegacy.client.renderer;

import com.github.smallinger.coppergolemlegacy.block.CopperGolemStatueBlock;
import com.github.smallinger.coppergolemlegacy.block.entity.CopperGolemStatueBlockEntity;
import com.github.smallinger.coppergolemlegacy.client.model.CopperGolemModel;
import com.github.smallinger.coppergolemlegacy.client.model.CopperGolemStatueModel;
import com.github.smallinger.coppergolemlegacy.entity.CopperGolemOxidationLevels;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CopperGolemStatueRenderer
implements BlockEntityRenderer<CopperGolemStatueBlockEntity> {
    private final Map<CopperGolemStatueBlock.Pose, CopperGolemStatueModel> models = new HashMap<CopperGolemStatueBlock.Pose, CopperGolemStatueModel>();

    public CopperGolemStatueRenderer(BlockEntityRendererProvider.Context context) {
        this.models.put(CopperGolemStatueBlock.Pose.STANDING, new CopperGolemStatueModel(context.bakeLayer(CopperGolemModel.STATUE_STANDING)));
        this.models.put(CopperGolemStatueBlock.Pose.RUNNING, new CopperGolemStatueModel(context.bakeLayer(CopperGolemModel.STATUE_RUNNING)));
        this.models.put(CopperGolemStatueBlock.Pose.SITTING, new CopperGolemStatueModel(context.bakeLayer(CopperGolemModel.STATUE_SITTING)));
        this.models.put(CopperGolemStatueBlock.Pose.STAR, new CopperGolemStatueModel(context.bakeLayer(CopperGolemModel.STATUE_STAR)));
    }

    public void render(CopperGolemStatueBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        BlockState blockState = blockEntity.getBlockState();
        Block block = blockState.getBlock();
        if (!(block instanceof CopperGolemStatueBlock)) {
            return;
        }
        CopperGolemStatueBlock statueBlock = (CopperGolemStatueBlock)block;
        CopperGolemStatueBlock.Pose pose = (CopperGolemStatueBlock.Pose)((Object)blockState.getValue(CopperGolemStatueBlock.POSE));
        Level level = blockEntity.getLevel();
        boolean hasLevel = level != null;
        Direction facing = hasLevel ? (Direction)blockState.getValue((Property)CopperGolemStatueBlock.FACING) : Direction.SOUTH;
        CopperGolemStatueModel model = this.models.get((Object)pose);
        if (model == null) {
            return;
        }
        ResourceLocation texture = CopperGolemOxidationLevels.getOxidationLevel(statueBlock.getWeatheringState()).texture();
        poseStack.pushPose();
        poseStack.translate(0.5, 0.0, 0.5);
        model.setupAnim(facing);
        RenderType renderType = RenderType.entityCutoutNoCull((ResourceLocation)texture);
        model.renderToBuffer(poseStack, bufferSource.getBuffer(renderType), packedLight, packedOverlay, -1);
        poseStack.popPose();
    }
}

