/*
 * Decompiled with CFR 0.152.
 */
package com.github.smallinger.coppergolemlegacy.client.renderer;

import com.github.smallinger.coppergolemlegacy.CopperGolemLegacy;
import com.github.smallinger.coppergolemlegacy.block.CopperGolemStatueBlock;
import com.github.smallinger.coppergolemlegacy.block.entity.CopperChestBlockEntity;
import com.github.smallinger.coppergolemlegacy.block.entity.CopperGolemStatueBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class CopperItemRenderer
extends BlockEntityWithoutLevelRenderer {
    public CopperItemRenderer() {
        super(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Item item = stack.getItem();
        if (!(item instanceof BlockItem)) {
            return;
        }
        BlockItem blockItem = (BlockItem)item;
        Block block = blockItem.getBlock();
        if (this.isChestBlock(block)) {
            this.renderChestItem(block, poseStack, bufferSource, packedLight, packedOverlay);
        } else if (block instanceof CopperGolemStatueBlock) {
            this.renderStatueItem(block, stack, poseStack, bufferSource, packedLight, packedOverlay);
        }
    }

    private boolean isChestBlock(Block block) {
        return block == CopperGolemLegacy.COPPER_CHEST.get() || block == CopperGolemLegacy.EXPOSED_COPPER_CHEST.get() || block == CopperGolemLegacy.WEATHERED_COPPER_CHEST.get() || block == CopperGolemLegacy.OXIDIZED_COPPER_CHEST.get() || block == CopperGolemLegacy.WAXED_COPPER_CHEST.get() || block == CopperGolemLegacy.WAXED_EXPOSED_COPPER_CHEST.get() || block == CopperGolemLegacy.WAXED_WEATHERED_COPPER_CHEST.get() || block == CopperGolemLegacy.WAXED_OXIDIZED_COPPER_CHEST.get();
    }

    private void renderChestItem(Block block, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        CopperChestBlockEntity blockEntity = new CopperChestBlockEntity(BlockPos.ZERO, block.defaultBlockState());
        Minecraft.getInstance().getBlockEntityRenderDispatcher().renderItem((BlockEntity)blockEntity, poseStack, bufferSource, packedLight, packedOverlay);
    }

    private void renderStatueItem(Block block, ItemStack stack, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        BlockState state = this.resolveBlockState(block, stack);
        CopperGolemStatueBlockEntity blockEntity = new CopperGolemStatueBlockEntity(BlockPos.ZERO, state);
        blockEntity.applyComponentsFromItemStack(stack);
        Minecraft.getInstance().getBlockEntityRenderDispatcher().renderItem((BlockEntity)blockEntity, poseStack, bufferSource, packedLight, packedOverlay);
    }

    private BlockState resolveBlockState(Block block, ItemStack stack) {
        BlockState state = block.defaultBlockState();
        BlockItemStateProperties properties = (BlockItemStateProperties)stack.get(DataComponents.BLOCK_STATE);
        if (properties != null && !properties.isEmpty()) {
            state = properties.apply(state);
        }
        return state;
    }
}

