/*
 * Decompiled with CFR 0.152.
 */
package com.github.smallinger.coppergolemlegacy.entity.ai.behavior;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.behavior.declarative.MemoryAccessor;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;

public class InteractWithDoor {
    private static final int COOLDOWN_BEFORE_RERUNNING_IN_SAME_NODE = 10;
    private static final double SKIP_CLOSING_DOOR_IF_FURTHER_AWAY_THAN = 3.0;
    private static final double MAX_DISTANCE_TO_HOLD_DOOR_OPEN_FOR_OTHER_MOBS = 2.0;

    public static BehaviorControl<LivingEntity> create() {
        MutableObject lastPathNode = new MutableObject(null);
        MutableInt cooldown = new MutableInt(0);
        return BehaviorBuilder.create(instance -> instance.group((App)instance.present(MemoryModuleType.PATH), (App)instance.registered(MemoryModuleType.DOORS_TO_CLOSE), (App)instance.registered(MemoryModuleType.NEAREST_LIVING_ENTITIES)).apply((Applicative)instance, (pathMemory, doorsToCloseMemory, nearestEntitiesMemory) -> (level, entity, gameTime) -> {
            Path path = (Path)instance.get(pathMemory);
            Optional<Set<GlobalPos>> doorsToClose = instance.tryGet(doorsToCloseMemory);
            if (!path.notStarted() && !path.isDone()) {
                DoorBlock door;
                BlockPos nextPos;
                BlockState nextState;
                if (Objects.equals(lastPathNode.getValue(), path.getNextNode())) {
                    cooldown.setValue(10);
                } else if (cooldown.decrementAndGet() > 0) {
                    return false;
                }
                lastPathNode.setValue((Object)path.getNextNode());
                Node previousNode = path.getPreviousNode();
                Node nextNode = path.getNextNode();
                BlockPos previousPos = previousNode.asBlockPos();
                BlockState previousState = level.getBlockState(previousPos);
                if (previousState.is(BlockTags.WOODEN_DOORS) && previousState.getBlock() instanceof DoorBlock) {
                    DoorBlock door2 = (DoorBlock)previousState.getBlock();
                    if (!door2.isOpen(previousState)) {
                        door2.setOpen((Entity)entity, (Level)level, previousState, previousPos, true);
                    }
                    doorsToClose = InteractWithDoor.rememberDoorToClose(doorsToCloseMemory, doorsToClose, level, previousPos);
                }
                if ((nextState = level.getBlockState(nextPos = nextNode.asBlockPos())).is(BlockTags.WOODEN_DOORS) && nextState.getBlock() instanceof DoorBlock && !(door = (DoorBlock)nextState.getBlock()).isOpen(nextState)) {
                    door.setOpen((Entity)entity, (Level)level, nextState, nextPos, true);
                    doorsToClose = InteractWithDoor.rememberDoorToClose(doorsToCloseMemory, doorsToClose, level, nextPos);
                }
                doorsToClose.ifPresent(doors -> InteractWithDoor.closeDoorsThatIHaveOpenedOrPassedThrough(level, entity, previousNode, nextNode, doors, instance.tryGet(nearestEntitiesMemory)));
                return true;
            }
            return false;
        }));
    }

    public static void closeDoorsThatIHaveOpenedOrPassedThrough(ServerLevel level, LivingEntity entity, @Nullable Node previous, @Nullable Node next, Set<GlobalPos> doorPositions, Optional<List<LivingEntity>> nearestLivingEntities) {
        Iterator<GlobalPos> iterator = doorPositions.iterator();
        while (iterator.hasNext()) {
            GlobalPos doorPos = iterator.next();
            BlockPos blockPos = doorPos.pos();
            if (previous != null && previous.asBlockPos().equals((Object)blockPos) || next != null && next.asBlockPos().equals((Object)blockPos)) continue;
            if (InteractWithDoor.isDoorTooFarAway(level, entity, doorPos)) {
                iterator.remove();
                continue;
            }
            BlockState blockState = level.getBlockState(blockPos);
            if (!blockState.is(BlockTags.WOODEN_DOORS) || !(blockState.getBlock() instanceof DoorBlock)) {
                iterator.remove();
                continue;
            }
            DoorBlock door = (DoorBlock)blockState.getBlock();
            if (!door.isOpen(blockState)) {
                iterator.remove();
                continue;
            }
            if (InteractWithDoor.areOtherMobsComingThroughDoor(entity, blockPos, nearestLivingEntities)) {
                iterator.remove();
                continue;
            }
            door.setOpen((Entity)entity, (Level)level, blockState, blockPos, false);
            iterator.remove();
        }
    }

    private static boolean areOtherMobsComingThroughDoor(LivingEntity entity, BlockPos doorPos, Optional<List<LivingEntity>> nearestLivingEntities) {
        if (nearestLivingEntities.isEmpty()) {
            return false;
        }
        return nearestLivingEntities.get().stream().filter(mob -> mob.getType() == entity.getType()).filter(mob -> doorPos.closerToCenterThan((Position)mob.position(), 2.0)).anyMatch(mob -> InteractWithDoor.isMobComingThroughDoor(mob.getBrain(), doorPos));
    }

    private static boolean isMobComingThroughDoor(Brain<?> brain, BlockPos doorPos) {
        if (!brain.hasMemoryValue(MemoryModuleType.PATH)) {
            return false;
        }
        Path path = (Path)brain.getMemory(MemoryModuleType.PATH).get();
        if (path.isDone()) {
            return false;
        }
        Node previousNode = path.getPreviousNode();
        if (previousNode == null) {
            return false;
        }
        Node nextNode = path.getNextNode();
        return doorPos.equals((Object)previousNode.asBlockPos()) || doorPos.equals((Object)nextNode.asBlockPos());
    }

    private static boolean isDoorTooFarAway(ServerLevel level, LivingEntity entity, GlobalPos doorPos) {
        return doorPos.dimension() != level.dimension() || !doorPos.pos().closerToCenterThan((Position)entity.position(), 3.0);
    }

    private static Optional<Set<GlobalPos>> rememberDoorToClose(MemoryAccessor<?, Set<GlobalPos>> doorsToCloseMemory, Optional<Set<GlobalPos>> doorPositions, ServerLevel level, BlockPos doorPos) {
        GlobalPos globalPos = GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)doorPos);
        return Optional.of(doorPositions.map(doors -> {
            doors.add(globalPos);
            return doors;
        }).orElseGet(() -> {
            HashSet newDoors = Sets.newHashSet((Object[])new GlobalPos[]{globalPos});
            doorsToCloseMemory.set((Object)newDoors);
            return newDoors;
        }));
    }
}

