/*
 * Decompiled with CFR 0.152.
 */
package com.github.smallinger.coppergolemlegacy.entity.ai.behavior;

import com.github.smallinger.coppergolemlegacy.CopperGolemLegacy;
import com.github.smallinger.coppergolemlegacy.ModMemoryTypes;
import com.github.smallinger.coppergolemlegacy.block.CopperButtonBlock;
import com.github.smallinger.coppergolemlegacy.entity.CopperGolemEntity;
import com.github.smallinger.coppergolemlegacy.entity.CopperGolemState;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class PressRandomCopperButton
extends Behavior<CopperGolemEntity> {
    private final float speedModifier;
    private final int horizontalSearchDistance;
    private final int verticalSearchDistance;
    private final int pressInterval;
    private final Random random = new Random();
    private final Map<GlobalPos, Long> visitedButtonTimestamps = new HashMap<GlobalPos, Long>();
    @Nullable
    private BlockPos targetButton;
    private int ticksSinceReached = 0;
    private long lastButtonPressTime = -1000L;

    public PressRandomCopperButton(float speedModifier, int horizontalSearchDistance, int verticalSearchDistance, int pressInterval) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)ModMemoryTypes.VISITED_BLOCK_POSITIONS.get()), (Object)MemoryStatus.REGISTERED), pressInterval);
        this.speedModifier = speedModifier;
        this.horizontalSearchDistance = horizontalSearchDistance;
        this.verticalSearchDistance = verticalSearchDistance;
        this.pressInterval = pressInterval;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, CopperGolemEntity golem) {
        if (this.targetButton != null) {
            return false;
        }
        long currentTime = level.getGameTime();
        int minWaitTime = 100 + this.random.nextInt(200);
        if (this.lastButtonPressTime > 0L && currentTime - this.lastButtonPressTime < (long)minWaitTime) {
            return false;
        }
        int randomCooldown = 400 + this.random.nextInt(400);
        this.visitedButtonTimestamps.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() >= (long)randomCooldown);
        BlockPos buttonPos = this.findNearestCopperButton(level, golem, currentTime);
        if (buttonPos != null) {
            this.targetButton = buttonPos;
            return true;
        }
        return false;
    }

    protected void start(ServerLevel level, CopperGolemEntity golem, long gameTime) {
        if (this.targetButton != null) {
            golem.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(this.targetButton, this.speedModifier, 0));
            golem.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new BlockPosTracker(this.targetButton));
        }
    }

    protected boolean canStillUse(ServerLevel level, CopperGolemEntity golem, long gameTime) {
        if (this.targetButton == null) {
            return false;
        }
        double distanceSqr = golem.blockPosition().distSqr((Vec3i)this.targetButton);
        if (distanceSqr <= 0.5) {
            if (this.ticksSinceReached == 0) {
                this.stopInPlace(golem);
            }
            ++this.ticksSinceReached;
            if (this.ticksSinceReached <= 5) {
                this.stopInPlace(golem);
            }
            if (this.ticksSinceReached == 6) {
                golem.setState(CopperGolemState.PRESSING_BUTTON);
            }
            if (this.ticksSinceReached == 14) {
                this.pressButton(level, golem, this.targetButton);
            }
            return this.ticksSinceReached < 30;
        }
        BlockState state = level.getBlockState(this.targetButton);
        if (!this.isCopperButton(state.getBlock())) {
            return false;
        }
        return this.ticksSinceReached < 200;
    }

    protected void stop(ServerLevel level, CopperGolemEntity golem, long gameTime) {
        golem.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        golem.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
        golem.setState(CopperGolemState.IDLE);
        this.targetButton = null;
        this.ticksSinceReached = 0;
    }

    private void pressButton(ServerLevel level, CopperGolemEntity golem, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof ButtonBlock) {
            CopperButtonBlock copperButton;
            ButtonBlock buttonBlock = (ButtonBlock)block;
            if (((Boolean)state.getValue((Property)BlockStateProperties.POWERED)).booleanValue()) {
                return;
            }
            if (block instanceof CopperButtonBlock && (copperButton = (CopperButtonBlock)block).getAge() == WeatheringCopper.WeatherState.OXIDIZED) {
                level.playSound(null, pos, SoundEvents.COPPER_HIT, SoundSource.BLOCKS, 1.0f, 1.0f);
                return;
            }
            BlockState poweredState = (BlockState)state.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(true));
            level.setBlock(pos, poweredState, 3);
            level.playSound(null, pos, SoundEvents.COPPER_HIT, SoundSource.BLOCKS, 0.3f, 0.6f);
            level.scheduleTick(pos, (Block)buttonBlock, 15);
            level.updateNeighborsAt(pos, (Block)buttonBlock);
            AttachFace face = (AttachFace)state.getValue((Property)BlockStateProperties.ATTACH_FACE);
            Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            Direction attachedDirection = face == AttachFace.FLOOR ? Direction.DOWN : (face == AttachFace.CEILING ? Direction.UP : facing.getOpposite());
            BlockPos attachedPos = pos.relative(attachedDirection);
            level.updateNeighborsAt(attachedPos, (Block)buttonBlock);
            GlobalPos globalPos = GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)pos);
            long currentTime = level.getGameTime();
            this.visitedButtonTimestamps.put(globalPos, currentTime);
            this.lastButtonPressTime = currentTime;
        }
    }

    @Nullable
    private BlockPos findNearestCopperButton(ServerLevel level, CopperGolemEntity golem, long currentTime) {
        BlockPos golemPos = golem.blockPosition();
        ArrayList<BlockPos> candidateButtons = new ArrayList<BlockPos>();
        int randomCooldown = 400 + this.random.nextInt(400);
        for (int x = -this.horizontalSearchDistance; x <= this.horizontalSearchDistance; ++x) {
            for (int y = -this.verticalSearchDistance; y <= this.verticalSearchDistance; ++y) {
                for (int z = -this.horizontalSearchDistance; z <= this.horizontalSearchDistance; ++z) {
                    GlobalPos globalPos;
                    Long lastVisitTime;
                    BlockPos checkPos = golemPos.offset(x, y, z);
                    BlockState state = level.getBlockState(checkPos);
                    if (!this.isCopperButton(state.getBlock()) || ((Boolean)state.getValue((Property)BlockStateProperties.POWERED)).booleanValue() || (lastVisitTime = this.visitedButtonTimestamps.get(globalPos = GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)checkPos))) != null && currentTime - lastVisitTime < (long)randomCooldown) continue;
                    candidateButtons.add(checkPos);
                }
            }
        }
        if (!candidateButtons.isEmpty()) {
            return (BlockPos)candidateButtons.get(golem.getRandom().nextInt(candidateButtons.size()));
        }
        return null;
    }

    private boolean isCopperButton(Block block) {
        return block == CopperGolemLegacy.COPPER_BUTTON.get() || block == CopperGolemLegacy.EXPOSED_COPPER_BUTTON.get() || block == CopperGolemLegacy.WEATHERED_COPPER_BUTTON.get() || block == CopperGolemLegacy.OXIDIZED_COPPER_BUTTON.get() || block == CopperGolemLegacy.WAXED_COPPER_BUTTON.get() || block == CopperGolemLegacy.WAXED_EXPOSED_COPPER_BUTTON.get() || block == CopperGolemLegacy.WAXED_WEATHERED_COPPER_BUTTON.get() || block == CopperGolemLegacy.WAXED_OXIDIZED_COPPER_BUTTON.get();
    }

    private void stopInPlace(CopperGolemEntity golem) {
        golem.getNavigation().stop();
        golem.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        golem.setXxa(0.0f);
        golem.setYya(0.0f);
        golem.setZza(0.0f);
        golem.setSpeed(0.0f);
        golem.setDeltaMovement(0.0, golem.getDeltaMovement().y, 0.0);
        golem.walkAnimation.setSpeed(0.0f);
    }
}

