/*
 * Decompiled with CFR 0.152.
 */
package com.github.smallinger.coppergolemlegacy.util;

import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class WeatheringHelper {
    public static final float OXIDATION_CHANCE = 0.05688889f;

    public static boolean tryWeather(BlockState state, ServerLevel level, BlockPos pos, RandomSource random, Function<Block, Optional<Block>> getNextBlock) {
        Optional<Block> nextBlock = getNextBlock.apply(state.getBlock());
        if (nextBlock.isPresent() && random.nextFloat() < 0.05688889f) {
            BlockState newState = nextBlock.get().withPropertiesOf(state);
            level.setBlockAndUpdate(pos, newState);
            return true;
        }
        return false;
    }

    public static boolean canWeather(BlockState state, Function<Block, Optional<Block>> getNextBlock) {
        return getNextBlock.apply(state.getBlock()).isPresent();
    }
}

