/*
 * Decompiled with CFR 0.152.
 */
package com.github.smallinger.coppergolemlegacy.block;

import com.github.smallinger.coppergolemlegacy.CopperGolemLegacy;
import com.github.smallinger.coppergolemlegacy.ModSounds;
import com.github.smallinger.coppergolemlegacy.block.entity.CopperGolemStatueBlockEntity;
import com.github.smallinger.coppergolemlegacy.entity.CopperGolemEntity;
import com.github.smallinger.coppergolemlegacy.util.WeatheringHelper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CopperGolemStatueBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock,
WeatheringCopper {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<Pose> POSE = EnumProperty.m_61587_((String)"pose", Pose.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0);
    private final WeatheringCopper.WeatherState weatheringState;

    public CopperGolemStatueBlock(WeatheringCopper.WeatherState weatheringState, BlockBehaviour.Properties properties) {
        super(properties);
        this.weatheringState = weatheringState;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(POSE, (Comparable)((Object)Pose.STANDING))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public WeatheringCopper.WeatherState getWeatheringState() {
        return this.weatheringState;
    }

    public WeatheringCopper.WeatherState getAge() {
        return this.weatheringState;
    }

    public static Optional<Block> getNextBlock(Block block) {
        if (block == CopperGolemLegacy.COPPER_GOLEM_STATUE.get()) {
            return Optional.of((Block)CopperGolemLegacy.EXPOSED_COPPER_GOLEM_STATUE.get());
        }
        if (block == CopperGolemLegacy.EXPOSED_COPPER_GOLEM_STATUE.get()) {
            return Optional.of((Block)CopperGolemLegacy.WEATHERED_COPPER_GOLEM_STATUE.get());
        }
        if (block == CopperGolemLegacy.WEATHERED_COPPER_GOLEM_STATUE.get()) {
            return Optional.of((Block)CopperGolemLegacy.OXIDIZED_COPPER_GOLEM_STATUE.get());
        }
        return WeatheringCopper.m_154904_((Block)block);
    }

    public static Optional<Block> getPreviousBlock(Block block) {
        if (block == CopperGolemLegacy.OXIDIZED_COPPER_GOLEM_STATUE.get()) {
            return Optional.of((Block)CopperGolemLegacy.WEATHERED_COPPER_GOLEM_STATUE.get());
        }
        if (block == CopperGolemLegacy.WEATHERED_COPPER_GOLEM_STATUE.get()) {
            return Optional.of((Block)CopperGolemLegacy.EXPOSED_COPPER_GOLEM_STATUE.get());
        }
        if (block == CopperGolemLegacy.EXPOSED_COPPER_GOLEM_STATUE.get()) {
            return Optional.of((Block)CopperGolemLegacy.COPPER_GOLEM_STATUE.get());
        }
        return Optional.empty();
    }

    public static Optional<Block> getWaxedBlock(Block block) {
        if (block == CopperGolemLegacy.COPPER_GOLEM_STATUE.get()) {
            return Optional.of((Block)CopperGolemLegacy.WAXED_COPPER_GOLEM_STATUE.get());
        }
        if (block == CopperGolemLegacy.EXPOSED_COPPER_GOLEM_STATUE.get()) {
            return Optional.of((Block)CopperGolemLegacy.WAXED_EXPOSED_COPPER_GOLEM_STATUE.get());
        }
        if (block == CopperGolemLegacy.WEATHERED_COPPER_GOLEM_STATUE.get()) {
            return Optional.of((Block)CopperGolemLegacy.WAXED_WEATHERED_COPPER_GOLEM_STATUE.get());
        }
        if (block == CopperGolemLegacy.OXIDIZED_COPPER_GOLEM_STATUE.get()) {
            return Optional.of((Block)CopperGolemLegacy.WAXED_OXIDIZED_COPPER_GOLEM_STATUE.get());
        }
        return Optional.empty();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, POSE, WATERLOGGED});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_204117_(ItemTags.f_271207_)) {
            Optional<Block> previousBlock = CopperGolemStatueBlock.getPreviousBlock(state.m_60734_());
            if (previousBlock.isPresent()) {
                level.m_5594_(player, pos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_5898_(player, 3005, pos, 0);
                if (!level.f_46443_) {
                    BlockState newState = (BlockState)((BlockState)((BlockState)previousBlock.get().m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)))).m_61124_(POSE, (Comparable)((Object)((Pose)((Object)state.m_61143_(POSE)))))).m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)WATERLOGGED)));
                    level.m_7731_(pos, newState, 3);
                    if (!player.m_7500_()) {
                        stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                    }
                }
                return InteractionResult.SUCCESS;
            }
            if (!level.m_5776_()) {
                CopperGolemStatueBlockEntity statueEntity;
                CopperGolemEntity golem;
                ServerLevel serverLevel = (ServerLevel)level;
                BlockEntity blockEntity = level.m_7702_(pos);
                if (blockEntity instanceof CopperGolemStatueBlockEntity && (golem = (statueEntity = (CopperGolemStatueBlockEntity)blockEntity).removeStatue(state, serverLevel)) != null) {
                    level.m_7471_(pos, false);
                    serverLevel.m_7967_((Entity)golem);
                    level.m_5594_(null, pos, (SoundEvent)ModSounds.COPPER_STATUE_BREAK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.m_142346_((Entity)player, GameEvent.f_157794_, pos);
                    stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                    return InteractionResult.SUCCESS;
                }
            }
            return InteractionResult.PASS;
        }
        if (stack.m_150930_(Items.f_42784_)) {
            Optional<Block> waxedBlock = CopperGolemStatueBlock.getWaxedBlock(state.m_60734_());
            if (waxedBlock.isPresent()) {
                level.m_5594_(player, pos, SoundEvents.f_144178_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_5898_(player, 3003, pos, 0);
                if (!level.f_46443_) {
                    BlockState waxedState = (BlockState)((BlockState)((BlockState)waxedBlock.get().m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)))).m_61124_(POSE, (Comparable)((Object)((Pose)((Object)state.m_61143_(POSE)))))).m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)WATERLOGGED)));
                    level.m_7731_(pos, waxedState, 3);
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        if (stack.m_41619_()) {
            if (!level.m_5776_()) {
                Pose currentPose = (Pose)((Object)state.m_61143_(POSE));
                Pose nextPose = currentPose.getNextPose();
                level.m_7731_(pos, (BlockState)state.m_61124_(POSE, (Comparable)((Object)nextPose)), 3);
                level.m_5594_(null, pos, (SoundEvent)ModSounds.COPPER_STATUE_HIT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CopperGolemStatueBlockEntity(pos, state);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        Optional<Block> nextBlock = CopperGolemStatueBlock.getNextBlock(state.m_60734_());
        if (nextBlock.isPresent() && random.m_188501_() < 0.05688889f) {
            BlockState newState = (BlockState)((BlockState)((BlockState)nextBlock.get().m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)))).m_61124_(POSE, (Comparable)((Object)((Pose)((Object)state.m_61143_(POSE)))))).m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)WATERLOGGED)));
            level.m_46597_(pos, newState);
        }
    }

    public boolean m_6724_(BlockState state) {
        return WeatheringHelper.canWeather(state, CopperGolemStatueBlock::getNextBlock);
    }

    public static enum Pose implements StringRepresentable
    {
        STANDING("standing"),
        RUNNING("running"),
        SITTING("sitting"),
        STAR("star");

        private final String name;

        private Pose(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public Pose getNextPose() {
            Pose[] poses = Pose.values();
            return poses[(this.ordinal() + 1) % poses.length];
        }
    }
}

