/*
 * Decompiled with CFR 0.152.
 */
package com.github.smallinger.coppergolemlegacy.client.renderer;

import com.github.smallinger.coppergolemlegacy.CopperGolemLegacy;
import com.github.smallinger.coppergolemlegacy.block.CopperGolemStatueBlock;
import com.github.smallinger.coppergolemlegacy.block.entity.CopperChestBlockEntity;
import com.github.smallinger.coppergolemlegacy.block.entity.CopperGolemStatueBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public class CopperItemRenderer
extends BlockEntityWithoutLevelRenderer {
    public CopperItemRenderer() {
        super(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
    }

    public void m_108829_(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Item item = stack.m_41720_();
        if (!(item instanceof BlockItem)) {
            return;
        }
        BlockItem blockItem = (BlockItem)item;
        Block block = blockItem.m_40614_();
        if (this.isChestBlock(block)) {
            this.renderChestItem(stack, block, poseStack, bufferSource, packedLight, packedOverlay);
        } else if (block instanceof CopperGolemStatueBlock) {
            CopperGolemStatueBlock statueBlock = (CopperGolemStatueBlock)block;
            this.renderStatueItem(stack, statueBlock, poseStack, bufferSource, packedLight, packedOverlay);
        }
    }

    private boolean isChestBlock(Block block) {
        return block == CopperGolemLegacy.COPPER_CHEST.get() || block == CopperGolemLegacy.EXPOSED_COPPER_CHEST.get() || block == CopperGolemLegacy.WEATHERED_COPPER_CHEST.get() || block == CopperGolemLegacy.OXIDIZED_COPPER_CHEST.get() || block == CopperGolemLegacy.WAXED_COPPER_CHEST.get() || block == CopperGolemLegacy.WAXED_EXPOSED_COPPER_CHEST.get() || block == CopperGolemLegacy.WAXED_WEATHERED_COPPER_CHEST.get() || block == CopperGolemLegacy.WAXED_OXIDIZED_COPPER_CHEST.get();
    }

    private void renderChestItem(ItemStack stack, Block block, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        BlockState state = this.getBlockStateFromStack(stack, block);
        CopperChestBlockEntity blockEntity = new CopperChestBlockEntity(BlockPos.f_121853_, state);
        Minecraft.m_91087_().m_167982_().m_112272_((BlockEntity)blockEntity, poseStack, bufferSource, packedLight, packedOverlay);
    }

    private void renderStatueItem(ItemStack stack, CopperGolemStatueBlock statueBlock, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        BlockState state = this.getBlockStateFromStack(stack, (Block)statueBlock);
        CopperGolemStatueBlockEntity blockEntity = new CopperGolemStatueBlockEntity(BlockPos.f_121853_, state);
        Minecraft.m_91087_().m_167982_().m_112272_((BlockEntity)blockEntity, poseStack, bufferSource, packedLight, packedOverlay);
    }

    private BlockState getBlockStateFromStack(ItemStack stack, Block block) {
        BlockState state = block.m_49966_();
        CompoundTag stateTag = stack.m_41737_("BlockStateTag");
        if (stateTag == null) {
            return state;
        }
        StateDefinition stateDefinition = block.m_49965_();
        for (String key : stateTag.m_128431_()) {
            Property property = stateDefinition.m_61081_(key);
            if (property == null) continue;
            state = CopperItemRenderer.applyProperty(state, property, stateTag.m_128461_(key));
        }
        return state;
    }

    private static <T extends Comparable<T>> BlockState applyProperty(BlockState state, Property<T> property, String value) {
        return property.m_6215_(value).map(parsed -> (BlockState)state.m_61124_(property, parsed)).orElse(state);
    }
}

