/*
 * Decompiled with CFR 0.152.
 */
package com.github.smallinger.coppergolemlegacy.entity.ai.behavior;

import com.github.smallinger.coppergolemlegacy.CopperGolemLegacy;
import com.github.smallinger.coppergolemlegacy.ModMemoryTypes;
import com.github.smallinger.coppergolemlegacy.block.CopperButtonBlock;
import com.github.smallinger.coppergolemlegacy.entity.CopperGolemEntity;
import com.github.smallinger.coppergolemlegacy.entity.CopperGolemState;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class PressRandomCopperButton
extends Behavior<CopperGolemEntity> {
    private final float speedModifier;
    private final int horizontalSearchDistance;
    private final int verticalSearchDistance;
    private final int pressInterval;
    private final Random random = new Random();
    private final Map<GlobalPos, Long> visitedButtonTimestamps = new HashMap<GlobalPos, Long>();
    @Nullable
    private BlockPos targetButton;
    private int ticksSinceReached = 0;
    private long lastButtonPressTime = -1000L;

    public PressRandomCopperButton(float speedModifier, int horizontalSearchDistance, int verticalSearchDistance, int pressInterval) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)ModMemoryTypes.VISITED_BLOCK_POSITIONS.get()), (Object)MemoryStatus.REGISTERED), pressInterval);
        this.speedModifier = speedModifier;
        this.horizontalSearchDistance = horizontalSearchDistance;
        this.verticalSearchDistance = verticalSearchDistance;
        this.pressInterval = pressInterval;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, CopperGolemEntity golem) {
        if (this.targetButton != null) {
            return false;
        }
        long currentTime = level.m_46467_();
        int minWaitTime = 100 + this.random.nextInt(200);
        if (this.lastButtonPressTime > 0L && currentTime - this.lastButtonPressTime < (long)minWaitTime) {
            return false;
        }
        int randomCooldown = 400 + this.random.nextInt(400);
        this.visitedButtonTimestamps.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() >= (long)randomCooldown);
        BlockPos buttonPos = this.findNearestCopperButton(level, golem, currentTime);
        if (buttonPos != null) {
            this.targetButton = buttonPos;
            return true;
        }
        return false;
    }

    protected void start(ServerLevel level, CopperGolemEntity golem, long gameTime) {
        if (this.targetButton != null) {
            golem.m_6274_().m_21879_((MemoryModuleType)ModMemoryTypes.IS_PRESSING_BUTTON.get(), (Object)true);
            golem.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(this.targetButton, this.speedModifier, 0));
            golem.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(this.targetButton));
        }
    }

    protected boolean canStillUse(ServerLevel level, CopperGolemEntity golem, long gameTime) {
        if (this.targetButton == null) {
            return false;
        }
        double distanceSqr = golem.m_20183_().m_123331_((Vec3i)this.targetButton);
        if (distanceSqr <= 0.5) {
            if (this.ticksSinceReached == 0) {
                this.stopInPlace(golem);
            }
            ++this.ticksSinceReached;
            if (this.ticksSinceReached <= 5) {
                this.stopInPlace(golem);
            }
            if (this.ticksSinceReached == 6) {
                golem.setState(CopperGolemState.PRESSING_BUTTON);
            }
            if (this.ticksSinceReached == 14) {
                this.pressButton(level, golem, this.targetButton);
            }
            return this.ticksSinceReached < 30;
        }
        BlockState state = level.m_8055_(this.targetButton);
        if (!this.isCopperButton(state.m_60734_())) {
            return false;
        }
        return this.ticksSinceReached < 200;
    }

    protected void stop(ServerLevel level, CopperGolemEntity golem, long gameTime) {
        golem.m_6274_().m_21936_((MemoryModuleType)ModMemoryTypes.IS_PRESSING_BUTTON.get());
        golem.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        golem.m_6274_().m_21936_(MemoryModuleType.f_26371_);
        golem.setState(CopperGolemState.IDLE);
        this.targetButton = null;
        this.ticksSinceReached = 0;
    }

    private void pressButton(ServerLevel level, CopperGolemEntity golem, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof ButtonBlock) {
            CopperButtonBlock copperButton;
            ButtonBlock buttonBlock = (ButtonBlock)block;
            if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_)).booleanValue()) {
                return;
            }
            if (block instanceof CopperButtonBlock && (copperButton = (CopperButtonBlock)block).getAge() == WeatheringCopper.WeatherState.OXIDIZED) {
                level.m_5594_(null, pos, SoundEvents.f_144120_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return;
            }
            BlockState poweredState = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(true));
            level.m_7731_(pos, poweredState, 3);
            level.m_5594_(null, pos, SoundEvents.f_144120_, SoundSource.BLOCKS, 0.3f, 0.6f);
            level.m_186460_(pos, (Block)buttonBlock, 15);
            level.m_46672_(pos, (Block)buttonBlock);
            AttachFace face = (AttachFace)state.m_61143_((Property)BlockStateProperties.f_61376_);
            Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            Direction attachedDirection = face == AttachFace.FLOOR ? Direction.DOWN : (face == AttachFace.CEILING ? Direction.UP : facing.m_122424_());
            BlockPos attachedPos = pos.m_121945_(attachedDirection);
            level.m_46672_(attachedPos, (Block)buttonBlock);
            GlobalPos globalPos = GlobalPos.m_122643_((ResourceKey)level.m_46472_(), (BlockPos)pos);
            long currentTime = level.m_46467_();
            this.visitedButtonTimestamps.put(globalPos, currentTime);
            this.lastButtonPressTime = currentTime;
        }
    }

    @Nullable
    private BlockPos findNearestCopperButton(ServerLevel level, CopperGolemEntity golem, long currentTime) {
        BlockPos golemPos = golem.m_20183_();
        ArrayList<BlockPos> candidateButtons = new ArrayList<BlockPos>();
        int randomCooldown = 400 + this.random.nextInt(400);
        for (int x = -this.horizontalSearchDistance; x <= this.horizontalSearchDistance; ++x) {
            for (int y = -this.verticalSearchDistance; y <= this.verticalSearchDistance; ++y) {
                for (int z = -this.horizontalSearchDistance; z <= this.horizontalSearchDistance; ++z) {
                    GlobalPos globalPos;
                    Long lastVisitTime;
                    BlockPos checkPos = golemPos.m_7918_(x, y, z);
                    BlockState state = level.m_8055_(checkPos);
                    if (!this.isCopperButton(state.m_60734_()) || ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_)).booleanValue() || (lastVisitTime = this.visitedButtonTimestamps.get(globalPos = GlobalPos.m_122643_((ResourceKey)level.m_46472_(), (BlockPos)checkPos))) != null && currentTime - lastVisitTime < (long)randomCooldown) continue;
                    candidateButtons.add(checkPos);
                }
            }
        }
        if (!candidateButtons.isEmpty()) {
            return (BlockPos)candidateButtons.get(golem.m_217043_().m_188503_(candidateButtons.size()));
        }
        return null;
    }

    private boolean isCopperButton(Block block) {
        return block == CopperGolemLegacy.COPPER_BUTTON.get() || block == CopperGolemLegacy.EXPOSED_COPPER_BUTTON.get() || block == CopperGolemLegacy.WEATHERED_COPPER_BUTTON.get() || block == CopperGolemLegacy.OXIDIZED_COPPER_BUTTON.get() || block == CopperGolemLegacy.WAXED_COPPER_BUTTON.get() || block == CopperGolemLegacy.WAXED_EXPOSED_COPPER_BUTTON.get() || block == CopperGolemLegacy.WAXED_WEATHERED_COPPER_BUTTON.get() || block == CopperGolemLegacy.WAXED_OXIDIZED_COPPER_BUTTON.get();
    }

    private void stopInPlace(CopperGolemEntity golem) {
        golem.m_21573_().m_26573_();
        golem.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        golem.m_21570_(0.0f);
        golem.m_21567_(0.0f);
        golem.m_21564_(0.0f);
        golem.m_7910_(0.0f);
        golem.m_20334_(0.0, golem.m_20184_().f_82480_, 0.0);
        golem.f_267362_.m_267771_(0.0f);
    }
}

