/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.wilderflowers.registry;

import cc.cassian.wilderflowers.WilderFlowers;
import cc.cassian.wilderflowers.blocks.FlowerBedBlock;
import cc.cassian.wilderflowers.blocks.FlowerGarlandBlock;
import cc.cassian.wilderflowers.items.FlowerGarlandItem;
import cc.cassian.wilderflowers.registry.CommonRegistry;
import cc.cassian.wilderflowers.registry.WildflowerSupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.jetbrains.annotations.NotNull;

public class WilderFlowersBlocks {
    public static ArrayList<WildflowerSupplier> WILDFLOWERS = new ArrayList();
    public static final WildflowerSupplier HOPEFUL_WILDFLOWERS = WilderFlowersBlocks.registerWildflowerBlock("hopeful_wildflowers");
    public static final WildflowerSupplier CHEERY_WILDFLOWERS = WilderFlowersBlocks.registerWildflowerBlock("cheery_wildflowers", true, false, Blocks.WILDFLOWERS);
    public static final WildflowerSupplier MOODY_WILDFLOWERS = WilderFlowersBlocks.registerWildflowerBlock("moody_wildflowers");
    public static final WildflowerSupplier PLAYFUL_WILDFLOWERS = WilderFlowersBlocks.registerWildflowerBlock("playful_wildflowers", true, false, Blocks.PINK_PETALS);
    public static final WildflowerSupplier CLOVERS = WilderFlowersBlocks.registerWildflowerBlock("clovers", false, true, null);

    private static WildflowerSupplier registerWildflowerBlock(String id, boolean generateGarland, boolean replaceable, Block flowerbed) {
        Supplier<FlowerGarlandBlock> flowerGarlandBlockSupplier;
        Supplier<Block> flowerBedBlockSupplier;
        if (flowerbed == null) {
            flowerBedBlockSupplier = CommonRegistry.registerBlock(id, () -> new FlowerBedBlock(WilderFlowersBlocks.flowerBedProperties(id, replaceable)));
            CommonRegistry.registerItem(id, () -> new BlockItem((Block)flowerBedBlockSupplier.get(), WilderFlowersBlocks.blockItemProperties(id)));
        } else {
            flowerBedBlockSupplier = () -> flowerbed;
        }
        if (generateGarland) {
            String garlandId = id.replace("flowers", "flower_garland");
            flowerGarlandBlockSupplier = CommonRegistry.registerBlock(garlandId, () -> new FlowerGarlandBlock(WilderFlowersBlocks.flowerBedProperties(garlandId, replaceable)));
            CommonRegistry.registerItem(garlandId, () -> new FlowerGarlandItem((Block)flowerGarlandBlockSupplier.get(), WilderFlowersBlocks.blockItemProperties(garlandId).equippableUnswappable(EquipmentSlot.HEAD)));
        } else {
            flowerGarlandBlockSupplier = null;
        }
        Supplier<Block> flowerPotSupplier = CommonRegistry.registerBlock("potted_" + id, () -> new FlowerPotBlock((Block)flowerBedBlockSupplier.get(), WilderFlowersBlocks.copy(Blocks.FLOWER_POT).setId(WilderFlowersBlocks.blockKey("potted_" + id))));
        WildflowerSupplier wildflowerSupplier = new WildflowerSupplier(id, flowerBedBlockSupplier, Optional.ofNullable(flowerGarlandBlockSupplier), flowerPotSupplier);
        WILDFLOWERS.add(wildflowerSupplier);
        return wildflowerSupplier;
    }

    private static BlockBehaviour.Properties copy(Block flowerPot) {
        return BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)flowerPot);
    }

    private static WildflowerSupplier registerWildflowerBlock(String id) {
        return WilderFlowersBlocks.registerWildflowerBlock(id, true, false, null);
    }

    static // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Item.Properties blockItemProperties(String id) {
        return new Item.Properties().useBlockDescriptionPrefix().setId(WilderFlowersBlocks.itemKey(id));
    }

    static ResourceKey<Block> blockKey(String id) {
        return ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)WilderFlowers.locate(id));
    }

    static ResourceKey<Item> itemKey(String id) {
        return ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)WilderFlowers.locate(id));
    }

    private static BlockBehaviour.Properties flowerBedProperties(String id, boolean replaceable) {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.of().sound(SoundType.PINK_PETALS).setId(WilderFlowersBlocks.blockKey(id)).noCollision();
        if (replaceable) {
            properties = properties.replaceable();
        }
        return properties;
    }

    public static void touch() {
    }

    public static List<ItemStack> getWildflowerItems() {
        ArrayList list = new ArrayList();
        WILDFLOWERS.forEach(wildflowerSupplier -> {
            if (wildflowerSupplier.flowerBedItem().builtInRegistryHolder().key().location().getNamespace().equals("wilderflowers")) {
                list.add(wildflowerSupplier.flowerBedItem().getDefaultInstance());
            }
            if (wildflowerSupplier.garland().isPresent()) {
                list.add(wildflowerSupplier.garlandItem().getDefaultInstance());
            }
        });
        return list.reversed();
    }
}

