/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.wilderflowers.blocks;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_10225;
import net.minecraft.class_156;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2429;
import net.minecraft.class_247;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;

public class FlowerGarlandBlock
extends class_2248 {
    public static final class_2746 NORTH = class_2741.field_12489;
    public static final class_2746 EAST = class_2741.field_12487;
    public static final class_2746 SOUTH = class_2741.field_12540;
    public static final class_2746 WEST = class_2741.field_12527;
    public static final Map<class_2350, class_2746> PROPERTY_BY_DIRECTION = (Map)class_2429.field_11329.entrySet().stream().filter(entry -> entry.getKey() != class_2350.field_11033 && entry.getKey() != class_2350.field_11036).collect(class_156.method_664());
    private static final class_265 WEST_AABB = class_2248.method_9541((double)0.0, (double)9.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0);
    private static final class_265 EAST_AABB = class_2248.method_9541((double)15.0, (double)9.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    private static final class_265 NORTH_AABB = class_2248.method_9541((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)15.0, (double)1.0);
    private static final class_265 SOUTH_AABB = class_2248.method_9541((double)0.0, (double)9.0, (double)15.0, (double)16.0, (double)15.0, (double)16.0);
    private static final class_265 SUPPORT_SHAPE = class_2248.method_9541((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private final Map<class_2680, class_265> shapesCache;

    public FlowerGarlandBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(false)));
        this.shapesCache = ImmutableMap.copyOf(this.field_10647.method_11662().stream().collect(Collectors.toMap(Function.identity(), FlowerGarlandBlock::calculateShape)));
    }

    private static class_265 calculateShape(class_2680 state) {
        class_265 voxelshape = class_259.method_1073();
        if (((Boolean)state.method_11654((class_2769)NORTH)).booleanValue()) {
            voxelshape = class_259.method_1084((class_265)voxelshape, (class_265)NORTH_AABB);
        }
        if (((Boolean)state.method_11654((class_2769)SOUTH)).booleanValue()) {
            voxelshape = class_259.method_1084((class_265)voxelshape, (class_265)SOUTH_AABB);
        }
        if (((Boolean)state.method_11654((class_2769)EAST)).booleanValue()) {
            voxelshape = class_259.method_1084((class_265)voxelshape, (class_265)EAST_AABB);
        }
        if (((Boolean)state.method_11654((class_2769)WEST)).booleanValue()) {
            voxelshape = class_259.method_1084((class_265)voxelshape, (class_265)WEST_AABB);
        }
        return voxelshape.method_1110() ? class_259.method_1077() : voxelshape;
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return this.shapesCache.get(state);
    }

    protected boolean method_9579(class_2680 state) {
        return true;
    }

    public boolean method_9558(class_2680 state, class_4538 level, class_2338 pos) {
        return this.hasFaces(this.getUpdatedState(state, (class_1922)level, pos));
    }

    private boolean hasFaces(class_2680 state) {
        return this.countFaces(state) > 0;
    }

    private int countFaces(class_2680 state) {
        int i = 0;
        for (class_2746 booleanproperty : PROPERTY_BY_DIRECTION.values()) {
            if (!((Boolean)state.method_11654((class_2769)booleanproperty)).booleanValue()) continue;
            ++i;
        }
        return i;
    }

    private boolean canSupportAtFace(class_1922 level, class_2338 pos, class_2350 direction) {
        if (direction.method_10166() == class_2350.class_2351.field_11052) {
            return false;
        }
        class_2338 blockpos = pos.method_10093(direction);
        return FlowerGarlandBlock.isAcceptableNeighbour(level, blockpos, direction);
    }

    public static boolean isAcceptableNeighbour(class_1922 blockReader, class_2338 neighborPos, class_2350 attachedFace) {
        class_2680 state = blockReader.method_8320(neighborPos);
        class_265 neighborSupportFaceShape = state.method_26222(blockReader, neighborPos).method_20538(attachedFace.method_10153());
        class_265 neighborCollisionFaceShape = state.method_26220(blockReader, neighborPos).method_20538(attachedFace.method_10153());
        return !class_259.method_1074((class_265)neighborCollisionFaceShape, (class_265)SUPPORT_SHAPE, (class_247)class_247.field_16893) || !class_259.method_1074((class_265)neighborSupportFaceShape, (class_265)SUPPORT_SHAPE, (class_247)class_247.field_16893);
    }

    private class_2680 getUpdatedState(class_2680 state, class_1922 level, class_2338 pos) {
        class_2338 blockpos = pos.method_10084();
        class_2680 blockstate = null;
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_2746 booleanproperty = FlowerGarlandBlock.getPropertyForFace(direction);
            if (!((Boolean)state.method_11654((class_2769)booleanproperty)).booleanValue()) continue;
            boolean flag = this.canSupportAtFace(level, pos, direction);
            if (!flag) {
                if (blockstate == null) {
                    blockstate = level.method_8320(blockpos);
                }
                flag = blockstate.method_27852((class_2248)this) && (Boolean)blockstate.method_11654((class_2769)booleanproperty) != false;
            }
            state = (class_2680)state.method_11657((class_2769)booleanproperty, (Comparable)Boolean.valueOf(flag));
        }
        return state;
    }

    protected class_2680 method_9559(class_2680 state, class_4538 level, class_10225 scheduledTickAccess, class_2338 currentPos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        if (direction.method_10166() == class_2350.class_2351.field_11052) {
            return super.method_9559(state, level, scheduledTickAccess, currentPos, direction, neighborPos, neighborState, random);
        }
        class_2680 blockstate = this.getUpdatedState(state, (class_1922)level, currentPos);
        return !this.hasFaces(blockstate) ? class_2246.field_10124.method_9564() : blockstate;
    }

    public boolean method_9616(class_2680 blockState, class_1750 blockPlaceContext) {
        if (!blockPlaceContext.method_8046() && blockPlaceContext.method_8041().method_31574(this.method_8389())) {
            return this.countFaces(blockState) < PROPERTY_BY_DIRECTION.size();
        }
        return super.method_9616(blockState, blockPlaceContext);
    }

    public class_2680 method_9605(class_1750 context) {
        class_2680 blockstate = context.method_8045().method_8320(context.method_8037());
        boolean flag = blockstate.method_27852((class_2248)this);
        class_2680 blockstate1 = flag ? blockstate : this.method_9564();
        for (class_2350 direction : context.method_7718()) {
            boolean flag1;
            if (direction.method_10166() == class_2350.class_2351.field_11052) continue;
            class_2746 booleanproperty = FlowerGarlandBlock.getPropertyForFace(direction);
            boolean bl = flag1 = flag && (Boolean)blockstate.method_11654((class_2769)booleanproperty) != false;
            if (flag1 || !this.canSupportAtFace((class_1922)context.method_8045(), context.method_8037(), direction)) continue;
            return (class_2680)blockstate1.method_11657((class_2769)booleanproperty, (Comparable)Boolean.valueOf(true));
        }
        return flag ? blockstate1 : null;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{NORTH, EAST, SOUTH, WEST});
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        switch (rotation) {
            case field_11464: {
                return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)))).method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)EAST)));
            }
            case field_11465: {
                return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)EAST)))).method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)));
            }
            case field_11463: {
                return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)EAST)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)));
            }
        }
        return state;
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        switch (mirror) {
            case field_11300: {
                return (class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)));
            }
            case field_11301: {
                return (class_2680)((class_2680)state.method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)EAST)));
            }
        }
        return super.method_9569(state, mirror);
    }

    public static class_2746 getPropertyForFace(class_2350 face) {
        return PROPERTY_BY_DIRECTION.get(face);
    }
}

