/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.wilderflowers.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class FlowerPetalParticle
extends TextureSheetParticle {
    private final float yRot;
    private final float yOffset;

    protected FlowerPetalParticle(ClientLevel level, double x, double y, double z, double vx, double vy, double vz) {
        super(level, x, y, z, vx, vy, vz);
        this.lifetime = 100 + this.random.nextInt(20);
        this.gravity = 0.01f;
        this.yd = -0.08f;
        this.xd = (-0.5 + (double)this.random.nextFloat()) / 10.0;
        this.zd = (-0.5 + (double)this.random.nextFloat()) / 10.0;
        this.quadSize = 0.5f;
        this.yOffset = this.random.nextFloat() / 10.0f;
        this.yRot = (float)(1.5707963267948966 * (double)this.random.nextInt(4));
    }

    public void tick() {
        super.tick();
        this.xd = Mth.clamp((double)(this.xd + (double)(this.random.nextFloat() / 1000.0f * (float)(this.random.nextBoolean() ? 1 : -1))), (double)-0.05f, (double)0.05f);
        this.zd = Mth.clamp((double)(this.zd + (double)(this.random.nextFloat() / 1000.0f * (float)(this.random.nextBoolean() ? 1 : -1))), (double)-0.05f, (double)0.05f);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void render(VertexConsumer buffer, Camera camera, float partialTicks) {
        Vec3 pos = new Vec3(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - camera.getPosition().x, Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - camera.getPosition().y, Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - camera.getPosition().z);
        float half = this.quadSize * 0.5f;
        Vector3f[] corners = new Vector3f[]{new Vector3f(-half, 0.0f, -half), new Vector3f(-half, 0.0f, half), new Vector3f(half, 0.0f, half), new Vector3f(half, 0.0f, -half)};
        float cos = Mth.cos((float)this.yRot);
        float sin = Mth.sin((float)this.yRot);
        for (Vector3f corner : corners) {
            float xOld = corner.x();
            float zOld = corner.z();
            corner.set(xOld * cos - zOld * sin, corner.y(), xOld * sin + zOld * cos);
            corner.add((float)pos.x, (float)pos.y + this.yOffset, (float)pos.z);
        }
        int light = this.getLightColor(partialTicks);
        float u0 = this.getU0();
        float u1 = this.getU1();
        float v0 = this.getV0();
        float v1 = this.getV1();
        buffer.addVertex(corners[0].x(), corners[0].y(), corners[0].z()).setUv(u1, v1).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(light);
        buffer.addVertex(corners[1].x(), corners[1].y(), corners[1].z()).setUv(u1, v0).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(light);
        buffer.addVertex(corners[2].x(), corners[2].y(), corners[2].z()).setUv(u0, v0).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(light);
        buffer.addVertex(corners[3].x(), corners[3].y(), corners[3].z()).setUv(u0, v1).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(light);
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double vx, double vy, double vz) {
            FlowerPetalParticle p = new FlowerPetalParticle(level, x, y, z, vx, vy, vz);
            p.pickSprite(this.sprites);
            return p;
        }
    }
}

