/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.wilderflowers.events;

import cc.cassian.wilderflowers.items.FlowerGarlandItem;
import cc.cassian.wilderflowers.registry.WilderFlowersBlocks;
import cc.cassian.wilderflowers.registry.WilderFlowersParticleTypes;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.Vec3;

public class FlowerGarlandEvent {
    private static final float STEP_LENGTH = 2.0f;
    private static final float PARTICLE_CHANCE = 0.25f;
    private static final float PARTICLE_CHANCE_SPRINTING = 0.75f;
    private static final float TWO_PARTICLE_CHANCE = 0.5f;
    private static final Map<UUID, Vec3> prevPositions = new HashMap<UUID, Vec3>();
    private static final Map<Item, SimpleParticleType> PARTICLES = new HashMap<Item, SimpleParticleType>();

    public static void tick(Minecraft mc) {
        ParticleStatus status = (ParticleStatus)mc.options.particles().get();
        LocalPlayer player = mc.player;
        if (status == ParticleStatus.MINIMAL) {
            return;
        }
        if (player == null) {
            return;
        }
        Item headItem = player.getItemBySlot(EquipmentSlot.HEAD).getItem();
        if (headItem instanceof FlowerGarlandItem && player.onGround()) {
            UUID playerId = player.getUUID();
            Vec3 playerPos = player.position();
            if (!prevPositions.containsKey(playerId)) {
                prevPositions.put(playerId, playerPos);
                return;
            }
            Vec3 prevPlayerPos = prevPositions.get(playerId);
            double distance = playerPos.distanceTo(prevPlayerPos);
            if (distance > 2.0) {
                float f = player.getRandom().nextFloat();
                float f2 = player.isSprinting() ? 0.75f : 0.25f;
                if (f <= f2) {
                    Vec3 movement = player.getDeltaMovement().normalize().reverse();
                    SimpleParticleType particle = PARTICLES.get(headItem);
                    if (particle != null) {
                        int particleCount = player.getRandom().nextFloat() <= 0.5f ? 1 : 2;
                        for (int i = 0; i < particleCount; ++i) {
                            player.level().addParticle((ParticleOptions)particle, playerPos.x() + movement.x / 2.0, playerPos.y() + 1.0 + (double)player.getRandom().nextFloat() * 0.4, playerPos.z() + movement.z / 2.0, 0.0, 0.0, 0.0);
                        }
                    }
                    prevPositions.put(playerId, playerPos);
                }
            }
        }
    }

    static {
        PARTICLES.put(WilderFlowersBlocks.CHEERY_WILDFLOWERS.garlandItem(), WilderFlowersParticleTypes.CHEERY_PETAL.get());
        PARTICLES.put(WilderFlowersBlocks.PLAYFUL_WILDFLOWERS.garlandItem(), WilderFlowersParticleTypes.PLAYFUL_PETAL.get());
        PARTICLES.put(WilderFlowersBlocks.HOPEFUL_WILDFLOWERS.garlandItem(), WilderFlowersParticleTypes.HOPEFUL_PETAL.get());
        PARTICLES.put(WilderFlowersBlocks.MOODY_WILDFLOWERS.garlandItem(), WilderFlowersParticleTypes.MOODY_PETAL.get());
    }
}

