/*
 * Decompiled with CFR 0.152.
 */
package com.davigj.wilderflowers.common.block;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FlowerGarlandBlock
extends Block {
    public static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    public static final BooleanProperty EAST = BlockStateProperties.f_61369_;
    public static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    public static final BooleanProperty WEST = BlockStateProperties.f_61371_;
    public static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = (Map)PipeBlock.f_55154_.entrySet().stream().filter(entry -> entry.getKey() != Direction.DOWN && entry.getKey() != Direction.UP).collect(Util.m_137448_());
    private static final VoxelShape WEST_AABB = Block.m_49796_((double)0.0, (double)9.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0);
    private static final VoxelShape EAST_AABB = Block.m_49796_((double)15.0, (double)9.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    private static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)15.0, (double)1.0);
    private static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)9.0, (double)15.0, (double)16.0, (double)15.0, (double)16.0);
    private static final VoxelShape SUPPORT_SHAPE = Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private final Map<BlockState, VoxelShape> shapesCache;

    public FlowerGarlandBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false)));
        this.shapesCache = ImmutableMap.copyOf(this.f_49792_.m_61056_().stream().collect(Collectors.toMap(Function.identity(), FlowerGarlandBlock::calculateShape)));
    }

    private static VoxelShape calculateShape(BlockState state) {
        VoxelShape voxelshape = Shapes.m_83040_();
        if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)NORTH_AABB);
        }
        if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)SOUTH_AABB);
        }
        if (((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)EAST_AABB);
        }
        if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)WEST_AABB);
        }
        return voxelshape.m_83281_() ? Shapes.m_83144_() : voxelshape;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapesCache.get(state);
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return this.hasFaces(this.getUpdatedState(state, (BlockGetter)level, pos));
    }

    private boolean hasFaces(BlockState state) {
        return this.countFaces(state) > 0;
    }

    private int countFaces(BlockState state) {
        int i = 0;
        for (BooleanProperty booleanproperty : PROPERTY_BY_DIRECTION.values()) {
            if (!((Boolean)state.m_61143_((Property)booleanproperty)).booleanValue()) continue;
            ++i;
        }
        return i;
    }

    private boolean canSupportAtFace(BlockGetter level, BlockPos pos, Direction direction) {
        if (direction.m_122434_() == Direction.Axis.Y) {
            return false;
        }
        BlockPos blockpos = pos.m_121945_(direction);
        return FlowerGarlandBlock.isAcceptableNeighbour(level, blockpos, direction);
    }

    public static boolean isAcceptableNeighbour(BlockGetter blockReader, BlockPos neighborPos, Direction attachedFace) {
        BlockState state = blockReader.m_8055_(neighborPos);
        VoxelShape neighborSupportFaceShape = state.m_60816_(blockReader, neighborPos).m_83263_(attachedFace.m_122424_());
        VoxelShape neighborCollisionFaceShape = state.m_60812_(blockReader, neighborPos).m_83263_(attachedFace.m_122424_());
        return !Shapes.m_83157_((VoxelShape)neighborCollisionFaceShape, (VoxelShape)SUPPORT_SHAPE, (BooleanOp)BooleanOp.f_82683_) || !Shapes.m_83157_((VoxelShape)neighborSupportFaceShape, (VoxelShape)SUPPORT_SHAPE, (BooleanOp)BooleanOp.f_82683_);
    }

    private BlockState getUpdatedState(BlockState state, BlockGetter level, BlockPos pos) {
        BlockPos blockpos = pos.m_7494_();
        BlockState blockstate = null;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BooleanProperty booleanproperty = FlowerGarlandBlock.getPropertyForFace(direction);
            if (!((Boolean)state.m_61143_((Property)booleanproperty)).booleanValue()) continue;
            boolean flag = this.canSupportAtFace(level, pos, direction);
            if (!flag) {
                if (blockstate == null) {
                    blockstate = level.m_8055_(blockpos);
                }
                flag = blockstate.m_60713_((Block)this) && (Boolean)blockstate.m_61143_((Property)booleanproperty) != false;
            }
            state = (BlockState)state.m_61124_((Property)booleanproperty, (Comparable)Boolean.valueOf(flag));
        }
        return state;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (direction.m_122434_() == Direction.Axis.Y) {
            return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
        }
        BlockState blockstate = this.getUpdatedState(state, (BlockGetter)level, currentPos);
        return !this.hasFaces(blockstate) ? Blocks.f_50016_.m_49966_() : blockstate;
    }

    public boolean m_6864_(BlockState blockState, BlockPlaceContext blockPlaceContext) {
        if (!blockPlaceContext.m_7078_() && blockPlaceContext.m_43722_().m_150930_(this.m_5456_())) {
            return this.countFaces(blockState) < PROPERTY_BY_DIRECTION.size();
        }
        return super.m_6864_(blockState, blockPlaceContext);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_());
        boolean flag = blockstate.m_60713_((Block)this);
        BlockState blockstate1 = flag ? blockstate : this.m_49966_();
        for (Direction direction : context.m_6232_()) {
            boolean flag1;
            if (direction.m_122434_() == Direction.Axis.Y) continue;
            BooleanProperty booleanproperty = FlowerGarlandBlock.getPropertyForFace(direction);
            boolean bl = flag1 = flag && (Boolean)blockstate.m_61143_((Property)booleanproperty) != false;
            if (flag1 || !this.canSupportAtFace((BlockGetter)context.m_43725_(), context.m_8083_(), direction)) continue;
            return (BlockState)blockstate1.m_61124_((Property)booleanproperty, (Comparable)Boolean.valueOf(true));
        }
        return flag ? blockstate1 : null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, EAST, SOUTH, WEST});
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)NORTH)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)EAST)));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)EAST)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)NORTH)));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)NORTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)EAST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)));
            }
        }
        return state;
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)NORTH)));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)EAST)));
            }
        }
        return super.m_6943_(state, mirror);
    }

    public static BooleanProperty getPropertyForFace(Direction face) {
        return PROPERTY_BY_DIRECTION.get(face);
    }
}

