/*
 * Decompiled with CFR 0.152.
 */
package com.davigj.wilderflowers.common.block;

import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FlowerBedBlock
extends BushBlock
implements BonemealableBlock {
    public static final int MIN_FLOWERS = 1;
    public static final int MAX_FLOWERS = 4;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final IntegerProperty AMOUNT = IntegerProperty.m_61631_((String)"flower_amount", (int)1, (int)4);
    private static final BiFunction<Direction, Integer, VoxelShape> SHAPE_BY_PROPERTIES = Util.m_143821_((direction, integer) -> {
        VoxelShape[] voxelShapes = new VoxelShape[]{Block.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)3.0, (double)16.0), Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)8.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)3.0, (double)8.0), Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)3.0, (double)16.0)};
        VoxelShape voxelShape = Shapes.m_83040_();
        for (int i = 0; i < integer; ++i) {
            int j = Math.floorMod(i - direction.m_122416_(), 4);
            voxelShape = Shapes.m_83110_((VoxelShape)voxelShape, (VoxelShape)voxelShapes[j]);
        }
        return FlowerBedBlock.singleEncompassing(voxelShape);
    });

    public FlowerBedBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)AMOUNT, (Comparable)Integer.valueOf(1)));
    }

    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)blockState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState blockState, Mirror mirror) {
        return blockState.m_60717_(mirror.m_54846_((Direction)blockState.m_61143_((Property)FACING)));
    }

    public boolean m_6864_(BlockState blockState, BlockPlaceContext blockPlaceContext) {
        return !blockPlaceContext.m_7078_() && blockPlaceContext.m_43722_().m_150930_(this.m_5456_()) && (Integer)blockState.m_61143_((Property)AMOUNT) < 4 || super.m_6864_(blockState, blockPlaceContext);
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE_BY_PROPERTIES.apply((Direction)blockState.m_61143_((Property)FACING), (Integer)blockState.m_61143_((Property)AMOUNT));
    }

    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        BlockState blockState = blockPlaceContext.m_43725_().m_8055_(blockPlaceContext.m_8083_());
        return blockState.m_60713_((Block)this) ? (BlockState)blockState.m_61124_((Property)AMOUNT, (Comparable)Integer.valueOf(Math.min(4, (Integer)blockState.m_61143_((Property)AMOUNT) + 1))) : (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)blockPlaceContext.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, AMOUNT});
    }

    public boolean m_7370_(BlockGetter level, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean m_214167_(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void m_214148_(ServerLevel serverLevel, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        int i = (Integer)blockState.m_61143_((Property)AMOUNT);
        if (i < 4) {
            serverLevel.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)AMOUNT, (Comparable)Integer.valueOf(i + 1)), 2);
        } else {
            FlowerBedBlock.m_49840_((Level)serverLevel, (BlockPos)blockPos, (ItemStack)new ItemStack((ItemLike)this));
        }
    }

    public static VoxelShape singleEncompassing(VoxelShape voxelShape) {
        return voxelShape.m_83281_() ? Shapes.m_83040_() : Shapes.m_83048_((double)voxelShape.m_83288_(Direction.Axis.X), (double)voxelShape.m_83288_(Direction.Axis.Y), (double)voxelShape.m_83288_(Direction.Axis.Z), (double)voxelShape.m_83297_(Direction.Axis.X), (double)voxelShape.m_83297_(Direction.Axis.Y), (double)voxelShape.m_83297_(Direction.Axis.Z));
    }
}

