/*
 * Decompiled with CFR 0.152.
 */
package com.davigj.wilderflowers.core.registry;

import com.davigj.wilderflowers.common.block.FlowerBedBlock;
import com.davigj.wilderflowers.common.block.FlowerGarlandBlock;
import com.davigj.wilderflowers.core.registry.BlockSupplier;
import com.davigj.wilderflowers.core.registry.WFItems;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="wilderflowers", bus=Mod.EventBusSubscriber.Bus.MOD)
public class WFBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"wilderflowers");
    public static final Map<ResourceLocation, RegistryObject<Block>> POTTED_PLANTS = new HashMap<ResourceLocation, RegistryObject<Block>>();
    public static BlockSupplier CHEERFUL_WILDFLOWERS = WFBlocks.registerBlock("cheery_wildflowers", () -> new FlowerBedBlock(WFBlocks.flowerBedProperties(false)), CreativeModeTab.f_40750_);
    public static BlockSupplier PINK_PETALS = WFBlocks.registerBlock("pink_petals", () -> new FlowerBedBlock(WFBlocks.flowerBedProperties(false)), CreativeModeTab.f_40750_);
    public static BlockSupplier CLOVERS = WFBlocks.registerBlock("clovers", () -> new FlowerBedBlock(WFBlocks.flowerBedProperties(true)), CreativeModeTab.f_40750_);
    public static BlockSupplier MOODY_WILDFLOWERS = WFBlocks.registerBlock("moody_wildflowers", () -> new FlowerBedBlock(WFBlocks.flowerBedProperties(false)), CreativeModeTab.f_40750_);
    public static BlockSupplier HOPEFUL_WILDFLOWERS = WFBlocks.registerBlock("hopeful_wildflowers", () -> new FlowerBedBlock(WFBlocks.flowerBedProperties(false)), CreativeModeTab.f_40750_);
    public static final RegistryObject<Block> POTTED_CHEERY_WILDFLOWERS = WFBlocks.registerPottedPlant(CHEERFUL_WILDFLOWERS);
    public static final RegistryObject<Block> POTTED_HOPEFUL_WILDFLOWERS = WFBlocks.registerPottedPlant(HOPEFUL_WILDFLOWERS);
    public static final RegistryObject<Block> POTTED_PLAYFUL_WILDFLOWERS = WFBlocks.registerPottedPlant(PINK_PETALS);
    public static final RegistryObject<Block> POTTED_MOODY_WILDFLOWERS = WFBlocks.registerPottedPlant(MOODY_WILDFLOWERS);
    public static final RegistryObject<Block> POTTED_CLOVERS = WFBlocks.registerPottedPlant(CLOVERS);
    public static RegistryObject<Block> CHEERY_WILDFLOWER_GARLAND = BLOCKS.register("cheery_wildflower_garland", () -> new FlowerGarlandBlock(WFBlocks.flowerBedProperties(false)));
    public static RegistryObject<Block> HOPEFUL_WILDFLOWER_GARLAND = BLOCKS.register("hopeful_wildflower_garland", () -> new FlowerGarlandBlock(WFBlocks.flowerBedProperties(false)));
    public static RegistryObject<Block> PLAYFUL_WILDFLOWER_GARLAND = BLOCKS.register("playful_wildflower_garland", () -> new FlowerGarlandBlock(WFBlocks.flowerBedProperties(false)));
    public static RegistryObject<Block> MOODY_WILDFLOWER_GARLAND = BLOCKS.register("moody_wildflower_garland", () -> new FlowerGarlandBlock(WFBlocks.flowerBedProperties(false)));
    public static final ArrayList<BlockSupplier> FOLIAGE_BLOCKS = new ArrayList();

    public static void addPottedPlants() {
        POTTED_PLANTS.forEach((arg_0, arg_1) -> ((FlowerPotBlock)((FlowerPotBlock)Blocks.f_50276_)).addPlant(arg_0, arg_1));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
        FOLIAGE_BLOCKS.add(CHEERFUL_WILDFLOWERS);
        FOLIAGE_BLOCKS.add(PINK_PETALS);
        FOLIAGE_BLOCKS.add(MOODY_WILDFLOWERS);
        FOLIAGE_BLOCKS.add(HOPEFUL_WILDFLOWERS);
    }

    public static RegistryObject<Block> registerPottedPlant(BlockSupplier block) {
        RegistryObject pottedBlock = BLOCKS.register("potted_" + block.getID(), () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, block.getBlockSupplier(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50276_)));
        POTTED_PLANTS.put(block.getItemSupplier().getId(), (RegistryObject<Block>)pottedBlock);
        return pottedBlock;
    }

    private static BlockBehaviour.Properties flowerBedProperties(boolean replaceable) {
        Material material = Material.f_76300_;
        if (replaceable) {
            material = Material.f_76302_;
        }
        return BlockBehaviour.Properties.m_60939_((Material)material).m_60910_().m_60918_(SoundType.f_154667_);
    }

    public static BlockSupplier registerBlock(String blockID, Supplier<Block> blockSupplier, CreativeModeTab tab) {
        RegistryObject block = BLOCKS.register(blockID, blockSupplier);
        RegistryObject item = WFItems.ITEMS.register(blockID, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41491_(tab)));
        return new BlockSupplier(blockID, (RegistryObject<Block>)block, (RegistryObject<BlockItem>)item);
    }
}

