/*
 * Decompiled with CFR 0.152.
 */
package me.alfie.immersiveenchanting;

import com.google.gson.Gson;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import me.alfie.immersiveenchanting.block.ModBlocks;
import me.alfie.immersiveenchanting.config.ImmersiveEnchantingConfig;
import me.alfie.immersiveenchanting.creativetab.ModCreativeTab;
import me.alfie.immersiveenchanting.datacomponents.EnchantmentDataComponent;
import me.alfie.immersiveenchanting.datacomponents.ModDataComponents;
import me.alfie.immersiveenchanting.datapack.EnchantmentCostDatapackHandler;
import me.alfie.immersiveenchanting.datapack.EnchantmentCostRegistry;
import me.alfie.immersiveenchanting.datapack.EnchantmentMetadataRegistry;
import me.alfie.immersiveenchanting.gui.EnchantingTableMenu;
import me.alfie.immersiveenchanting.gui.ModMenus;
import me.alfie.immersiveenchanting.item.ModItems;
import me.alfie.immersiveenchanting.lootmodifier.ModLootModifiers;
import me.alfie.immersiveenchanting.networking.CheckBookshelfPacket;
import me.alfie.immersiveenchanting.networking.EnchantmentCostPacket;
import me.alfie.immersiveenchanting.networking.EnchantmentPacket;
import me.alfie.immersiveenchanting.networking.ServerPayloadHandler;
import me.alfie.immersiveenchanting.networking.SyncEnchantmentCostRegistryPacket;
import me.alfie.immersiveenchanting.networking.UnlockedEnchantmentsPacket;
import me.alfie.immersiveenchanting.networking.UpdateScrollableCanvas;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import org.slf4j.Logger;

@Mod(value="immersiveenchanting")
public class ImmersiveEnchanting {
    public static final String MODID = "immersiveenchanting";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static EnchantmentCostDatapackHandler enchantmentCostsDatapack = new EnchantmentCostDatapackHandler(new Gson(), "enchantment_costs");
    public static EnchantmentCostRegistry serverEnchantmentCostRegistry;
    public static EnchantmentCostRegistry clientEnchantmentCostRegistry;

    public ImmersiveEnchanting(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::onClientStart);
        modEventBus.addListener(this::buildCreativeTab);
        NeoForge.EVENT_BUS.register((Object)this);
        ModItems.register(modEventBus);
        ModMenus.register(modEventBus);
        ModLootModifiers.register(modEventBus);
        ModDataComponents.register(modEventBus);
        ModCreativeTab.register(modEventBus);
        ModBlocks.register(modEventBus);
        modEventBus.addListener(ModMenus::registerMenuScreens);
        modEventBus.addListener(EnchantmentPacket::register);
        modEventBus.addListener(CheckBookshelfPacket::register);
        modEventBus.addListener(UnlockedEnchantmentsPacket::register);
        modEventBus.addListener(EnchantmentCostPacket::register);
        modEventBus.addListener(UpdateScrollableCanvas::register);
        modEventBus.addListener(SyncEnchantmentCostRegistryPacket::register);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ImmersiveEnchantingConfig.CONFIG_SPEC);
    }

    @SubscribeEvent
    public void onServerStart(ServerStartedEvent event) {
        enchantmentCostsDatapack.setServer(event.getServer());
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    public void onClientStart(FMLClientSetupEvent event) {
        clientEnchantmentCostRegistry = new EnchantmentCostRegistry();
        ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
        EnchantmentMetadataRegistry.loadIcons(resourceManager);
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            SyncEnchantmentCostRegistryPacket.syncClientWithServer(player2);
        }
    }

    @SubscribeEvent
    public void reloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)enchantmentCostsDatapack);
    }

    public void buildCreativeTab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == ModCreativeTab.ENCHANTING_TAB.get()) {
            event.accept(new ItemStack((ItemLike)Items.ENCHANTING_TABLE));
            event.accept(new ItemStack((ItemLike)Items.CHISELED_BOOKSHELF));
            event.accept(new ItemStack(ModItems.CREATIVE_BOOKSHELF));
            event.accept(new ItemStack((ItemLike)Items.LAPIS_LAZULI));
            HashSet addedItems = new HashSet();
            HolderLookup.RegistryLookup enchantmentRegistryLookup = event.getParameters().holders().lookupOrThrow(Registries.ENCHANTMENT);
            enchantmentRegistryLookup.listElements().forEach(holder -> {
                ResourceLocation id = holder.key().location();
                ItemStack bookStack = new ItemStack((ItemLike)ModItems.ANCIENT_BOOK.get());
                bookStack.set((DataComponentType)ModDataComponents.ENCHANTMENT.get(), (Object)new EnchantmentDataComponent(id.toString()));
                event.accept(bookStack);
            });
        }
    }

    @SubscribeEvent
    public void onVillagerTrades(VillagerTradesEvent event) {
        if (event.getType() == VillagerProfession.LIBRARIAN) {
            Int2ObjectMap trades = event.getTrades();
            IntIterator intIterator = trades.keySet().iterator();
            while (intIterator.hasNext()) {
                int level = (Integer)intIterator.next();
                List tradeList = (List)trades.get(level);
                if (tradeList == null) continue;
                tradeList.removeIf(listing -> listing instanceof VillagerTrades.EnchantBookForEmeralds);
            }
        }
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        Player player = event.getEntity();
        if (!level.isClientSide && level.getBlockState(pos).getBlock() == Blocks.ENCHANTING_TABLE) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.openMenu((MenuProvider)new SimpleMenuProvider((id, inv, p) -> new EnchantingTableMenu(id, inv, level, pos), (Component)Component.literal((String)"Enchanting Table")), buf -> buf.writeBlockPos(pos));
                ServerPayloadHandler.checkBookshelvesAndUpdateClient(pos, player.level(), serverPlayer);
            }
        }
    }

    public static Registry<Enchantment> getEnchantmentRegistry(RegistryAccess access) {
        return access.registryOrThrow(Registries.ENCHANTMENT);
    }

    public static Optional<Holder.Reference<Enchantment>> getEnchantmentHolder(HolderLookup<Enchantment> lookup, String locationNamespace) {
        try {
            ResourceLocation location = ResourceLocation.tryParse((String)locationNamespace);
            if (location == null) {
                return Optional.empty();
            }
            ResourceKey key = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)location);
            return lookup.get(key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }
}

