/*
 * Decompiled with CFR 0.152.
 */
package me.alfie.immersiveenchanting.datapack;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.Map;
import me.alfie.immersiveenchanting.ImmersiveEnchanting;
import me.alfie.immersiveenchanting.datapack.EnchantmentCost;
import me.alfie.immersiveenchanting.datapack.EnchantmentCostRegistry;
import me.alfie.immersiveenchanting.networking.SyncEnchantmentCostRegistryPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class EnchantmentCostDatapackHandler
extends SimpleJsonResourceReloadListener {
    private final Gson gson;
    public static final String DIRECTORY = "enchantment_costs";
    private MinecraftServer server;

    public EnchantmentCostDatapackHandler(Gson gson, String directory) {
        super(gson, directory);
        this.gson = gson;
    }

    public void setServer(MinecraftServer server) {
        this.server = server;
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        if (ImmersiveEnchanting.serverEnchantmentCostRegistry == null) {
            ImmersiveEnchanting.serverEnchantmentCostRegistry = new EnchantmentCostRegistry();
        }
        ImmersiveEnchanting.serverEnchantmentCostRegistry.clear();
        int recipeCount = 0;
        for (Map.Entry<ResourceLocation, JsonElement> entry : object.entrySet()) {
            ResourceLocation fileId = entry.getKey();
            JsonElement json = entry.getValue();
            EnchantmentCost enchantmentCost = (EnchantmentCost)this.gson.fromJson(json, EnchantmentCost.class);
            String[] parts = fileId.getPath().split("/", 2);
            if (parts.length != 2) continue;
            ResourceLocation enchantmentId = ResourceLocation.fromNamespaceAndPath((String)parts[0], (String)parts[1]);
            ImmersiveEnchanting.serverEnchantmentCostRegistry.getCostRegistry().put(enchantmentId, enchantmentCost);
            ++recipeCount;
        }
        ImmersiveEnchanting.LOGGER.info("Loaded " + recipeCount + " enchantment costs.");
        if (this.server != null) {
            for (ServerPlayer player : this.server.getPlayerList().getPlayers()) {
                SyncEnchantmentCostRegistryPacket.syncClientWithServer(player);
                ImmersiveEnchanting.LOGGER.info("Reloaded enchantment cost registry for all clients.");
            }
        }
    }
}

