/*
 * Decompiled with CFR 0.152.
 */
package me.alfie.immersiveenchanting.datapack;

import java.util.HashMap;
import java.util.Map;
import me.alfie.immersiveenchanting.datapack.EnchantmentCost;
import me.alfie.immersiveenchanting.datapack.LevelCost;
import net.minecraft.resources.ResourceLocation;

public class EnchantmentCostRegistry {
    private final Map<ResourceLocation, EnchantmentCost> COST_REGISTRY = new HashMap<ResourceLocation, EnchantmentCost>();
    private static final EnchantmentCost EMPTY = new EnchantmentCost();

    public EnchantmentCost getEnchantmentCost(ResourceLocation enchantmentNamespace) {
        return this.COST_REGISTRY.getOrDefault(enchantmentNamespace, EMPTY);
    }

    public LevelCost getLevelCost(ResourceLocation enchantmentId, int level) {
        EnchantmentCost data = this.COST_REGISTRY.get(enchantmentId);
        if (data == null) {
            return null;
        }
        return data.getLevel(level);
    }

    public void clear() {
        this.COST_REGISTRY.clear();
    }

    public int getHighestEnchantmentLevel() {
        return this.COST_REGISTRY.values().stream().mapToInt(EnchantmentCost::getHighestLevel).max().orElse(0);
    }

    public Map<ResourceLocation, EnchantmentCost> getCostRegistry() {
        return this.COST_REGISTRY;
    }
}

