/*
 * Decompiled with CFR 0.152.
 */
package me.alfie.immersiveenchanting.datapack;

import java.util.HashMap;
import java.util.Map;
import me.alfie.immersiveenchanting.ImmersiveEnchanting;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;

public class EnchantmentMetadataRegistry {
    private static final Map<ResourceLocation, ResourceLocation> ICONS = new HashMap<ResourceLocation, ResourceLocation>();

    public static ResourceLocation getIconTexture(String enchantmentNamespace) {
        return ICONS.get(ResourceLocation.tryParse((String)enchantmentNamespace));
    }

    public static Map<ResourceLocation, ResourceLocation> getIcons() {
        return ICONS;
    }

    public static void loadIcons(ResourceManager resourceManager) {
        ICONS.clear();
        for (String namespace : resourceManager.getNamespaces()) {
            if (!namespace.equals("immersiveenchanting")) continue;
            Map iconFiles = resourceManager.listResources("textures/gui/enchantment_icons", rl -> rl.getPath().endsWith(".png"));
            for (ResourceLocation fileRL : iconFiles.keySet()) {
                String path = fileRL.getPath();
                String relative = path.substring("textures/gui/enchantment_icons/".length());
                String[] parts = relative.split("/", 2);
                if (parts.length != 2) continue;
                String enchantmentNamespace = parts[0];
                String fileName = parts[1];
                String enchantmentPath = fileName.replace(".png", "");
                ResourceLocation enchantmentRL = ResourceLocation.fromNamespaceAndPath((String)enchantmentNamespace, (String)enchantmentPath);
                ICONS.put(enchantmentRL, fileRL);
            }
        }
        ImmersiveEnchanting.LOGGER.info("Loaded " + ICONS.size() + " enchantment icons from textures/gui/enchantment_icons");
    }
}

