/*
 * Decompiled with CFR 0.152.
 */
package me.alfie.immersiveenchanting.gui;

import me.alfie.immersiveenchanting.enums.EnchantingNodeType;
import me.alfie.immersiveenchanting.gui.EnchantingTableScreen;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;

public class EnchantingNode {
    private int x;
    private int y;
    private final EnchantingNodeType node_type;
    static final int width = 26;
    static final int height = 26;
    private boolean obtained;
    private final ResourceLocation icon_texture;
    private final int enchantmentLevel;
    private final ResourceKey<Enchantment> enchantment;
    private final String enchantmentNamespace;
    final boolean isBranchUnlocked;
    private final ResourceLocation LOCKED_ICON = ResourceLocation.fromNamespaceAndPath((String)"immersiveenchanting", (String)"textures/gui/enchantment_icons/locked_enchantment.png");

    public EnchantingNode(EnchantingNodeType node_type, ResourceLocation icon_texture, int enchantmentLevel, String enchantmentNamespace, boolean isBranchUnlocked) {
        ResourceKey key;
        this.isBranchUnlocked = isBranchUnlocked;
        this.enchantmentLevel = enchantmentLevel;
        this.enchantmentNamespace = enchantmentNamespace;
        ResourceLocation location = ResourceLocation.parse((String)enchantmentNamespace);
        this.enchantment = key = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)location);
        if (isBranchUnlocked) {
            this.node_type = node_type;
            this.icon_texture = icon_texture;
        } else {
            this.node_type = EnchantingNodeType.LOCKED;
            this.icon_texture = this.LOCKED_ICON;
        }
    }

    public ResourceLocation getCurrentTexture() {
        return this.obtained ? this.node_type.getObtainedTexture() : this.node_type.getUnobtainedTexture();
    }

    public boolean isInViewport(double scrollX, double scrollY, int viewportWidth, int viewportHeight) {
        return (double)(this.getX() + 26) >= scrollX && (double)this.getX() <= scrollX + (double)viewportWidth && (double)(this.getY() + 26) >= scrollY && (double)this.getY() <= scrollY + (double)viewportHeight;
    }

    public void render(GuiGraphics guiGraphics, EnchantingTableScreen screen) {
        guiGraphics.blit(this.getCurrentTexture(), this.x - (int)screen.scrollX, this.y - (int)screen.scrollY, 0.0f, 0.0f, 26, 26, 26, 26);
        guiGraphics.blit(this.icon_texture, this.x - (int)screen.scrollX + 4, this.y - (int)screen.scrollY + 4, 0.0f, 0.0f, 16, 16, 16, 16);
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean isMouseOver(double mouseX, double mouseY, EnchantingTableScreen screen) {
        int drawX = this.x - (int)screen.scrollX;
        int drawY = this.y - (int)screen.scrollY;
        int nodeLeft = drawX;
        int nodeTop = drawY;
        int nodeRight = drawX + 26;
        int nodeBottom = drawY + 26;
        int viewportLeft = screen.canvasLeftPos;
        int viewportTop = screen.canvasTopPos;
        int viewportRight = viewportLeft + screen.viewportWidth;
        int viewportBottom = viewportTop + screen.viewportHeight;
        int visibleLeft = Math.max(nodeLeft, viewportLeft);
        int visibleTop = Math.max(nodeTop, viewportTop);
        int visibleRight = Math.min(nodeRight, viewportRight);
        int visibleBottom = Math.min(nodeBottom, viewportBottom);
        if (visibleLeft >= visibleRight || visibleTop >= visibleBottom) {
            return false;
        }
        return mouseX >= (double)visibleLeft && mouseX < (double)visibleRight && mouseY >= (double)visibleTop && mouseY < (double)visibleBottom;
    }

    public int getEnchantmentLevel() {
        return this.enchantmentLevel;
    }

    public String getEnchantmentNamespace() {
        return this.enchantmentNamespace;
    }

    public ResourceKey<Enchantment> getEnchantment() {
        return this.enchantment;
    }

    public void setObtained(boolean obtained) {
        this.obtained = obtained;
    }

    public boolean isObtained() {
        return this.obtained;
    }
}

