/*
 * Decompiled with CFR 0.152.
 */
package me.alfie.immersiveenchanting.gui;

import java.util.ArrayList;
import java.util.List;
import me.alfie.immersiveenchanting.ImmersiveEnchanting;
import me.alfie.immersiveenchanting.datapack.EnchantmentMetadataRegistry;
import me.alfie.immersiveenchanting.enums.EnchantingNodeType;
import me.alfie.immersiveenchanting.gui.EnchantingNode;
import me.alfie.immersiveenchanting.gui.EnchantingTableScreen;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import org.joml.Vector2i;

public class EnchantingNodeBranch {
    private final List<EnchantingNode> nodes = new ArrayList<EnchantingNode>();
    private EnchantingTableScreen screen;
    private final float branchAngle;
    private final String enchantmentNamespace;
    private int equippedLevel;
    private boolean isBranchUnlocked;
    private Player player;
    public static final int NODE_STEP = 80;

    public EnchantingNodeBranch(EnchantingTableScreen screen, float branchAngle, String enchantmentNamespace, int equippedLevel, boolean isBranchUnlocked, Player player) {
        int maxEnchantmentLevel;
        this.screen = screen;
        this.branchAngle = branchAngle;
        this.enchantmentNamespace = enchantmentNamespace;
        this.equippedLevel = equippedLevel;
        this.isBranchUnlocked = isBranchUnlocked;
        this.player = player;
        ResourceLocation icon_texture = ResourceLocation.fromNamespaceAndPath((String)"immersiveenchanting", (String)"textures/item/ancient_book.png");
        if (EnchantmentMetadataRegistry.getIcons().containsKey(ResourceLocation.tryParse((String)enchantmentNamespace))) {
            icon_texture = EnchantmentMetadataRegistry.getIconTexture(enchantmentNamespace);
        }
        if (ImmersiveEnchanting.clientEnchantmentCostRegistry.getCostRegistry().containsKey(ResourceLocation.parse((String)enchantmentNamespace))) {
            maxEnchantmentLevel = ImmersiveEnchanting.clientEnchantmentCostRegistry.getEnchantmentCost(ResourceLocation.parse((String)enchantmentNamespace)).getHighestLevel();
        } else {
            Registry<Enchantment> enchantmentRegistry = ImmersiveEnchanting.getEnchantmentRegistry(player.registryAccess());
            maxEnchantmentLevel = ((Enchantment)enchantmentRegistry.get(ResourceLocation.parse((String)enchantmentNamespace))).getMaxLevel();
        }
        int maxVisibleLevel = Math.min(equippedLevel + 1, maxEnchantmentLevel);
        for (int i = 1; i <= maxVisibleLevel; ++i) {
            EnchantingNodeType nodeType = i == maxEnchantmentLevel ? EnchantingNodeType.ELITE : EnchantingNodeType.BASIC;
            EnchantingNode node = new EnchantingNode(nodeType, icon_texture, i, enchantmentNamespace, this.isBranchUnlocked);
            if (i <= equippedLevel) {
                node.setObtained(true);
            }
            this.addNode(node);
        }
    }

    public void addNode(EnchantingNode node) {
        this.nodes.add(node);
        this.screen.rendered_nodes.add(node);
    }

    public List<EnchantingNode> getNodes() {
        return this.nodes;
    }

    public void placeNodesAlongLine() {
        Vector2i center = new Vector2i(this.screen.canvasLeftPos + this.screen.scrollableCanvasWidth / 2, this.screen.canvasTopPos + this.screen.scrollableCanvasHeight / 2);
        double stepX = Math.cos(this.branchAngle) * 80.0;
        double stepY = Math.sin(this.branchAngle) * 80.0;
        for (int i = 0; i < this.nodes.size(); ++i) {
            int x = (int)Math.round((double)center.x + stepX * (double)(i + 1));
            int y = (int)Math.round((double)center.y + stepY * (double)(i + 1));
            this.nodes.get(i).setX(x - 13);
            this.nodes.get(i).setY(y - 13);
        }
    }

    public void drawNodeConnections(GuiGraphics guiGraphics) {
        for (int i = 0; i < this.nodes.size(); ++i) {
            if (i == 0) {
                this.connectNodeToCenter(guiGraphics, this.nodes.get(i));
                continue;
            }
            this.connectNodes(guiGraphics, this.nodes.get(i - 1), this.nodes.get(i));
        }
    }

    private void connectNodeToCenter(GuiGraphics guiGraphics, EnchantingNode node) {
        int ax = this.screen.canvasLeftPos + this.screen.scrollableCanvasWidth / 2 - (int)this.screen.scrollX;
        int ay = this.screen.canvasTopPos + this.screen.scrollableCanvasHeight / 2 - (int)this.screen.scrollY;
        int bx = node.getX() + 13 - (int)this.screen.scrollX;
        int by = node.getY() + 13 - (int)this.screen.scrollY;
        this.drawConnection(guiGraphics, ax, ay, bx, by);
    }

    private void connectNodes(GuiGraphics guiGraphics, EnchantingNode node1, EnchantingNode node2) {
        int ax = node1.getX() + 13 - (int)this.screen.scrollX;
        int ay = node1.getY() + 13 - (int)this.screen.scrollY;
        int bx = node2.getX() + 13 - (int)this.screen.scrollX;
        int by = node2.getY() + 13 - (int)this.screen.scrollY;
        this.drawConnection(guiGraphics, ax, ay, bx, by);
    }

    public void drawConnection(GuiGraphics graphics, int x1, int y1, int x2, int y2) {
        int borderColor = -16777216;
        int lineColor = -1;
        if (y1 == y2) {
            int minX = Math.min(x1, x2);
            int maxX = Math.max(x1, x2);
            graphics.fill(minX, y1, maxX + 1, y1 + 1, lineColor);
            graphics.fill(minX, y1 - 1, maxX + 1, y1, borderColor);
            graphics.fill(minX, y1 + 1, maxX + 1, y1 + 2, borderColor);
            return;
        }
        if (x1 == x2) {
            int minY = Math.min(y1, y2);
            int maxY = Math.max(y1, y2);
            graphics.fill(x1, minY, x1 + 1, maxY + 1, lineColor);
            graphics.fill(x1 - 1, minY, x1, maxY + 1, borderColor);
            graphics.fill(x1 + 1, minY, x1 + 2, maxY + 1, borderColor);
            return;
        }
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        int sx = x1 < x2 ? 1 : -1;
        int sy = y1 < y2 ? 1 : -1;
        int err = dx - dy;
        while (true) {
            graphics.fill(x1, y1, x1 + 1, y1 + 1, lineColor);
            graphics.fill(x1 - 1, y1, x1, y1 + 1, borderColor);
            graphics.fill(x1 + 1, y1, x1 + 2, y1 + 1, borderColor);
            graphics.fill(x1, y1 - 1, x1 + 1, y1, borderColor);
            graphics.fill(x1, y1 + 1, x1 + 1, y1 + 2, borderColor);
            if (x1 == x2 && y1 == y2) break;
            int e2 = 2 * err;
            if (e2 > -dy) {
                err -= dy;
                x1 += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            y1 += sy;
        }
    }
}

