/*
 * Decompiled with CFR 0.152.
 */
package me.alfie.immersiveenchanting.gui;

import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;

public class EnchantingNodeTooltip {
    public static void renderEnchantmentTooltip(GuiGraphics gg, Font font, int mouseX, int mouseY, Component text, ItemStack cost) {
        int padding = 4;
        int itemSize = 16;
        int spacing = 4;
        int textWidth = font.width((FormattedText)text);
        int costLabelWidth = font.width("Cost:");
        Objects.requireNonNull(font);
        int lineHeight = 9;
        int costLineWidth = cost.isEmpty() ? costLabelWidth : costLabelWidth + spacing + itemSize;
        int width = padding + Math.max(textWidth, costLineWidth) + padding;
        int height = padding + lineHeight + spacing + itemSize + padding;
        int x = mouseX + 8;
        int y = mouseY - 12;
        int borderColor = -14415797;
        int backgroundColor = -267386864;
        EnchantingNodeTooltip.drawTooltipBox(gg, x, y, width, height, borderColor, backgroundColor);
        int contentX = x + padding;
        int contentY = y + padding;
        gg.drawString(font, text, contentX, contentY, 0xFFFFFF);
        int costY = contentY + lineHeight + spacing;
        gg.drawString(font, "Cost:", contentX, costY + (itemSize - lineHeight) / 2, 0xAAAAAA);
        if (!cost.isEmpty()) {
            int itemX = contentX + costLabelWidth + spacing;
            gg.renderItem(cost, itemX, costY);
            gg.renderItemDecorations(font, cost, itemX, costY);
        } else {
            int freeX = contentX + costLabelWidth + spacing;
            gg.drawString(font, "Free", freeX, costY + (itemSize - lineHeight) / 2, 0x55FF55);
        }
    }

    private static void drawTooltipBox(GuiGraphics gg, int x, int y, int width, int height, int borderColor, int backgroundColor) {
        gg.fill(x, y, x + width, y + height, borderColor);
        gg.fill(x + 1, y + 1, x + width - 1, y + height - 1, backgroundColor);
    }
}

