/*
 * Decompiled with CFR 0.152.
 */
package me.alfie.immersiveenchanting.gui;

import java.util.Set;
import me.alfie.immersiveenchanting.gui.ModMenus;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MaceItem;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.joml.Vector2i;

public class EnchantingTableMenu
extends AbstractContainerMenu {
    private BlockPos blockPos;
    private ContainerLevelAccess access;
    private final Container container = new SimpleContainer(3);
    private Level level;
    private Set<String> unlockedEnchantments;

    public EnchantingTableMenu(int containerId, Inventory playerInventory, Level level, BlockPos pos) {
        super(ModMenus.ENCHANTING_TABLE_MENU.get(), containerId);
        this.level = level;
        this.blockPos = pos;
        this.access = ContainerLevelAccess.create((Level)level, (BlockPos)pos);
        this.setupSlots(playerInventory);
    }

    public EnchantingTableMenu(int containerId, Inventory playerInventory, FriendlyByteBuf buf) {
        this(containerId, playerInventory, playerInventory.player.level(), buf.readBlockPos());
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack originalStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack stackInSlot = slot.getItem();
            originalStack = stackInSlot.copy();
            if (index == 0 ? !this.moveItemStackTo(stackInSlot, 3, 39, true) : (index == 1 ? !this.moveItemStackTo(stackInSlot, 3, 39, true) : (index == 2 ? !this.moveItemStackTo(stackInSlot, 3, 39, true) : (stackInSlot.getItem() instanceof PickaxeItem || stackInSlot.getItem() instanceof SwordItem || stackInSlot.getItem() instanceof AxeItem || stackInSlot.getItem() instanceof ShovelItem || stackInSlot.getItem() instanceof HoeItem || stackInSlot.getItem() instanceof ArmorItem || stackInSlot.getItem() instanceof BowItem || stackInSlot.getItem() instanceof CrossbowItem || stackInSlot.getItem() instanceof FishingRodItem || stackInSlot.getItem() instanceof TridentItem || stackInSlot.getItem() instanceof MaceItem || stackInSlot.getItem() instanceof ElytraItem || stackInSlot.getItem() instanceof ShieldItem || stackInSlot.getItem() instanceof FlintAndSteelItem || stackInSlot.getItem() instanceof BrushItem || stackInSlot.getItem() instanceof ShearsItem ? !this.moveItemStackTo(stackInSlot, 0, 1, false) : (stackInSlot.is(Items.LAPIS_LAZULI) ? !this.moveItemStackTo(stackInSlot, 1, 2, false) : !this.moveItemStackTo(stackInSlot, 2, 3, false)))))) {
                return ItemStack.EMPTY;
            }
            if (stackInSlot.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return originalStack;
    }

    public boolean stillValid(Player player) {
        return AbstractContainerMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)Blocks.ENCHANTING_TABLE);
    }

    public void updateScrollablePositions(Vector2i pos) {
        this.getSlot(0).isActive();
        this.addSlot(new Slot(this.container, 0, 0, 0));
    }

    public void setupSlots(Inventory playerInventory) {
        this.addSlot(new Slot(this.container, 0, 106, 110));
        this.addSlot(new Slot(this.container, 1, 70, 110));
        this.addSlot(new Slot(this.container, 2, 142, 110));
        int startX = 34;
        int startY = 136;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, startX + col * 18, startY + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInventory, col, startX + col * 18, startY + 58));
        }
    }

    public void removed(Player player) {
        super.removed(player);
        if (!player.level().isClientSide) {
            for (int i = 0; i < this.container.getContainerSize(); ++i) {
                ItemStack stack = this.container.removeItemNoUpdate(i);
                if (stack.isEmpty()) continue;
                player.getInventory().placeItemBackInInventory(stack);
            }
        }
    }

    public void setUnlockedEnchantments(Set<String> unlockedEnchantments) {
        this.unlockedEnchantments = unlockedEnchantments;
    }

    public Set<String> getUnlockedEnchantments() {
        return this.unlockedEnchantments;
    }
}

