/*
 * Decompiled with CFR 0.152.
 */
package me.alfie.immersiveenchanting.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import me.alfie.immersiveenchanting.ImmersiveEnchanting;
import me.alfie.immersiveenchanting.config.ImmersiveEnchantingConfig;
import me.alfie.immersiveenchanting.gui.EnchantingNode;
import me.alfie.immersiveenchanting.gui.EnchantingNodeBranch;
import me.alfie.immersiveenchanting.gui.EnchantingNodeTooltip;
import me.alfie.immersiveenchanting.gui.EnchantingTableMenu;
import me.alfie.immersiveenchanting.networking.EnchantmentPacket;
import me.alfie.immersiveenchanting.networking.UpdateScrollableCanvas;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Vector2i;

public class EnchantingTableScreen
extends AbstractContainerScreen<EnchantingTableMenu> {
    public static final ResourceLocation ENCHANTING_TABLE_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"immersiveenchanting", (String)"textures/gui/container/enchanting_table.png");
    public static final ResourceLocation TILE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"immersiveenchanting", (String)"textures/gui/container/background.png");
    public static final ResourceLocation BOOK_OPEN_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"immersiveenchanting", (String)"textures/gui/container/book_open_shadow.png");
    public static final ResourceLocation BOOK_CLOSED_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"immersiveenchanting", (String)"textures/gui/container/book_closed.png");
    private final int tileSize = 16;
    private final int viewportStartX = 10;
    final int viewportStartY = 7;
    final int viewportWidth = 208;
    final int viewportHeight = 92;
    int scrollableCanvasWidth = 1024;
    int scrollableCanvasHeight = 1024;
    int canvasLeftPos;
    int canvasTopPos;
    private boolean croppingEnabled = true;
    int canvasCenterOffsetX = 99 - this.scrollableCanvasWidth / 2 + 16;
    int canvasCenterOffsetY = 42 - this.scrollableCanvasHeight / 2 + 16;
    double scrollX = 0.0;
    double scrollY = 0.0;
    private boolean dragging = false;
    private double dragStartMouseX = 0.0;
    private double dragStartMouseY = 0.0;
    private double dragStartScrollX = 0.0;
    private double dragStartScrollY = 0.0;
    final List<EnchantingNode> rendered_nodes = new ArrayList<EnchantingNode>();
    public final List<EnchantingNodeBranch> branches = new ArrayList<EnchantingNodeBranch>();
    private ItemStack lastStack = ItemStack.EMPTY;
    private Player player;
    private ItemStack renderCostStack;

    public EnchantingTableScreen(EnchantingTableMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.titleLabelX = 10;
        this.inventoryLabelX = 10;
        this.imageHeight = 219;
        this.imageWidth = 228;
        this.scrollX = (double)this.scrollableCanvasWidth / 2.0 - 104.0;
        this.scrollY = (double)this.scrollableCanvasHeight / 2.0 - 46.0;
        this.player = playerInventory.player;
    }

    public void init() {
        super.init();
        PacketDistributor.sendToServer((CustomPacketPayload)new UpdateScrollableCanvas(0), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.canvasLeftPos = this.leftPos + 10;
        this.canvasTopPos = this.topPos + 7;
        this.branches.clear();
        this.rendered_nodes.clear();
        this.onSlot0Changed();
    }

    public void buildScrollableCanvas(int highestEnchantmentLevel) {
        int pixels = 160 * highestEnchantmentLevel;
        int margin = 64;
        int rounded = (pixels + 16 - 1) / 16 * 16;
        this.scrollableCanvasWidth = rounded + margin;
        this.scrollableCanvasHeight = rounded + margin;
        this.scrollX = (double)this.scrollableCanvasWidth / 2.0 - 104.0;
        this.scrollY = (double)this.scrollableCanvasHeight / 2.0 - 46.0;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int viewportLeft = this.leftPos + 10;
        int viewportTop = this.topPos + 7;
        int viewportRight = viewportLeft + 208;
        int viewportBottom = viewportTop + 92;
        if (this.croppingEnabled) {
            double scale = this.minecraft.getWindow().getGuiScale();
            RenderSystem.enableScissor((int)((int)((double)viewportLeft * scale)), (int)((int)((double)(this.height - viewportBottom) * scale)), (int)((int)(208.0 * scale)), (int)((int)(92.0 * scale)));
        }
        int numberOfTilesX = this.scrollableCanvasWidth / 16;
        int numberOfTilesY = this.scrollableCanvasHeight / 16;
        for (int x = 0; x < numberOfTilesX; ++x) {
            for (int y = 0; y < numberOfTilesY; ++y) {
                int tileScreenX = this.canvasLeftPos + x * 16 - (int)this.scrollX;
                int tileScreenY = this.canvasTopPos + y * 16 - (int)this.scrollY;
                if (tileScreenX + 16 < viewportLeft || tileScreenX > viewportRight || tileScreenY + 16 < viewportTop || tileScreenY > viewportBottom) continue;
                guiGraphics.blit(TILE_TEXTURE, this.canvasLeftPos + x * 16 - (int)this.scrollX, this.canvasTopPos + y * 16 - (int)this.scrollY, 0.0f, 0.0f, 16, 16, 16, 16);
            }
        }
        for (EnchantingNodeBranch branch : this.branches) {
            branch.drawNodeConnections(guiGraphics);
        }
        for (EnchantingNode node : this.rendered_nodes) {
            node.render(guiGraphics, this);
        }
        guiGraphics.blit(BOOK_OPEN_TEXTURE, this.centerOnCanvas((int)26, (int)20).x - (int)this.scrollX, this.centerOnCanvas((int)26, (int)20).y - (int)this.scrollY, 0.0f, 0.0f, 26, 20, 26, 20);
        ItemStack stack = ((EnchantingTableMenu)this.menu).getSlot(0).getItem();
        guiGraphics.renderItem(stack, this.centerOnCanvas((int)16, (int)16).x - (int)this.scrollX, this.centerOnCanvas((int)16, (int)16).y - (int)this.scrollY);
        RenderSystem.disableScissor();
        guiGraphics.blit(ENCHANTING_TABLE_BACKGROUND, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    public ArrayList<Float> generateBranchAngles(int totalBranches) {
        ArrayList<Float> angles = new ArrayList<Float>();
        for (int i = 0; i < totalBranches; ++i) {
            float angle = (float)((double)(i * 2) * Math.PI / (double)totalBranches);
            angles.add(Float.valueOf(angle));
        }
        return angles;
    }

    public void buildNodeBranches(ItemStack current_item) {
        HashSet<String> validEnchantments = new HashSet<String>();
        Set<String> unlockedEnchantments = ((EnchantingTableMenu)this.menu).getUnlockedEnchantments();
        RegistryAccess registryAccess = this.player.registryAccess();
        HolderLookup.RegistryLookup lookup = registryAccess.lookupOrThrow(Registries.ENCHANTMENT);
        List allEnchantments = lookup.listElements().toList();
        for (int i = 0; i < allEnchantments.size(); ++i) {
            ResourceLocation keyLocation;
            Holder.Reference holder2 = (Holder.Reference)allEnchantments.get(i);
            if (holder2.is(EnchantmentTags.CURSE) || (keyLocation = holder2.key().location()).equals((Object)ResourceLocation.parse((String)"minecraft:mending")) && !ImmersiveEnchantingConfig.isMendingEnabled()) continue;
            ItemEnchantments itemEnchantments = current_item.getTagEnchantments();
            ArrayList currentHolders = new ArrayList(itemEnchantments.keySet());
            currentHolders.remove(holder2);
            if (!EnchantmentHelper.isEnchantmentCompatible(currentHolders, (Holder)holder2) || !current_item.getItem().supportsEnchantment(current_item, (Holder)holder2)) continue;
            validEnchantments.add(holder2.key().location().toString());
        }
        ArrayList<Float> angles = this.generateBranchAngles(validEnchantments.size());
        int i = 0;
        for (String enchantmentNamespace : validEnchantments) {
            boolean isUnlocked = unlockedEnchantments.contains(enchantmentNamespace);
            AtomicInteger enchantmentLevel = new AtomicInteger();
            Optional<Holder.Reference<Enchantment>> optionalHolder = ImmersiveEnchanting.getEnchantmentHolder((HolderLookup<Enchantment>)lookup, enchantmentNamespace);
            optionalHolder.ifPresent(holder -> enchantmentLevel.set(current_item.getItem().getEnchantmentLevel(current_item, (Holder)holder)));
            this.branches.add(new EnchantingNodeBranch(this, ((Float)angles.get(i)).floatValue(), enchantmentNamespace, enchantmentLevel.get(), isUnlocked, this.player));
            ++i;
        }
    }

    public void onSlot0Changed() {
        this.player.playSound(SoundEvents.BOOK_PAGE_TURN);
        this.branches.clear();
        this.rendered_nodes.clear();
        ItemStack current_item = ((EnchantingTableMenu)this.menu).getSlot(0).getItem();
        this.buildNodeBranches(current_item);
        int largestBranchLevel = 1;
        for (EnchantingNodeBranch branch : this.branches) {
            largestBranchLevel = Math.max(largestBranchLevel, branch.getNodes().size());
        }
        for (EnchantingNodeBranch branch : this.branches) {
            branch.placeNodesAlongLine();
        }
    }

    public void containerTick() {
        super.containerTick();
        ItemStack current_item = ((EnchantingTableMenu)this.menu).getSlot(0).getItem();
        if (!ItemStack.isSameItemSameComponents((ItemStack)current_item, (ItemStack)this.lastStack)) {
            this.lastStack = current_item.copy();
            this.onSlot0Changed();
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        boolean hoveringAnyNode = false;
        for (EnchantingNode node : this.rendered_nodes) {
            if (!node.isMouseOver(mouseX, mouseY, this)) continue;
            hoveringAnyNode = true;
            if (node.isBranchUnlocked) {
                RegistryAccess registryAccess = this.player.registryAccess();
                HolderLookup.RegistryLookup lookup = registryAccess.lookupOrThrow(Registries.ENCHANTMENT);
                Optional<Holder.Reference<Enchantment>> enchantmentHolder = ImmersiveEnchanting.getEnchantmentHolder((HolderLookup<Enchantment>)lookup, node.getEnchantmentNamespace());
                MutableComponent enchantmentName = (MutableComponent)Enchantment.getFullname((Holder)((Holder)enchantmentHolder.get()), (int)node.getEnchantmentLevel());
                List<MutableComponent> tooltip = List.of(enchantmentName.withStyle(ChatFormatting.WHITE));
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate(0.0f, 0.0f, 400.0f);
                if (this.renderCostStack == null) {
                    this.renderCostStack = ImmersiveEnchanting.clientEnchantmentCostRegistry.getEnchantmentCost(ResourceLocation.parse((String)node.getEnchantmentNamespace())).getLevel(node.getEnchantmentLevel()).asItemStack();
                }
                EnchantingNodeTooltip.renderEnchantmentTooltip(guiGraphics, this.font, mouseX, mouseY, (Component)tooltip.getFirst(), this.renderCostStack);
                guiGraphics.pose().popPose();
                continue;
            }
            List<MutableComponent> tooltip = List.of(Component.translatable((String)"gui.immersiveenchanting.locked_enchantment").withStyle(ChatFormatting.RED), Component.translatable((String)"gui.immersiveenchanting.locked_enchantment_hint").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            guiGraphics.renderComponentTooltip(this.font, tooltip, mouseX, mouseY);
        }
        if (!hoveringAnyNode && this.renderCostStack != null) {
            this.renderCostStack = null;
        }
        super.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            for (EnchantingNode node : this.rendered_nodes) {
                if (!node.isMouseOver(mouseX, mouseY, this)) continue;
                this.onNodeClicked(node);
                return true;
            }
            int viewportLeft = this.leftPos + 10;
            int viewportTop = this.topPos + 7;
            int viewportRight = viewportLeft + 208;
            int viewportBottom = viewportTop + 92;
            if (mouseX >= (double)viewportLeft && mouseX < (double)viewportRight && mouseY >= (double)viewportTop && mouseY < (double)viewportBottom) {
                this.dragging = true;
                this.dragStartMouseX = mouseX;
                this.dragStartMouseY = mouseY;
                this.dragStartScrollX = this.scrollX;
                this.dragStartScrollY = this.scrollY;
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.dragging && button == 0) {
            this.scrollX = this.dragStartScrollX + (this.dragStartMouseX - mouseX);
            this.scrollY = this.dragStartScrollY + (this.dragStartMouseY - mouseY);
            if (this.scrollX + (double)this.canvasLeftPos < (double)this.canvasLeftPos) {
                this.scrollX = 0.0;
            }
            if (this.scrollY + (double)this.canvasTopPos < (double)this.canvasTopPos) {
                this.scrollY = 0.0;
            }
            if (this.scrollX > (double)(this.scrollableCanvasWidth - 208)) {
                this.scrollX = this.scrollableCanvasWidth - 208;
            }
            if (this.scrollY > (double)(this.scrollableCanvasHeight - 92)) {
                this.scrollY = this.scrollableCanvasHeight - 92;
            }
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.dragging = false;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public Vector2i centerOnCanvas(int textureWidth, int textureHeight) {
        int x = this.canvasLeftPos + this.scrollableCanvasWidth / 2 - textureWidth / 2;
        int y = this.canvasTopPos + this.scrollableCanvasHeight / 2 - textureHeight / 2;
        return new Vector2i(x, y);
    }

    private void onNodeClicked(EnchantingNode node) {
        if (!node.isObtained() && node.isBranchUnlocked) {
            ItemStack stack = ((EnchantingTableMenu)this.menu).getSlot(0).getItem();
            PacketDistributor.sendToServer((CustomPacketPayload)new EnchantmentPacket(0, node.getEnchantmentNamespace(), node.getEnchantmentLevel()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void setRenderCostTo(ItemStack costStack) {
        this.renderCostStack = costStack;
    }
}

