/*
 * Decompiled with CFR 0.152.
 */
package me.alfie.immersiveenchanting.item;

import java.util.List;
import me.alfie.immersiveenchanting.datacomponents.EnchantmentDataComponent;
import me.alfie.immersiveenchanting.datacomponents.ModDataComponents;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.moddiscovery.ModInfo;

public class AncientBook
extends Item {
    public AncientBook(Item.Properties properties) {
        super(properties.stacksTo(1).rarity(Rarity.UNCOMMON));
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        EnchantmentDataComponent enchantmentDataComponent = (EnchantmentDataComponent)stack.get((DataComponentType)ModDataComponents.ENCHANTMENT.get());
        if (enchantmentDataComponent != null) {
            RegistryAccess registryAccess = Minecraft.getInstance().level.registryAccess();
            Registry enchantmentRegistry = registryAccess.registryOrThrow(Registries.ENCHANTMENT);
            Enchantment enchantment = (Enchantment)enchantmentRegistry.get(ResourceLocation.parse((String)enchantmentDataComponent.enchantmentResourceLocation()));
            MutableComponent loreText = Component.translatable((String)"lore.immersiveenchanting.ancient_book");
            MutableComponent enchantName = (MutableComponent)enchantment.description();
            loreText.withStyle(ChatFormatting.GOLD);
            MutableComponent fullTooltip = loreText.append(" ").append((Component)enchantName);
            tooltipComponents.add((Component)fullTooltip);
            ResourceLocation enchantmentResourceLocation = ResourceLocation.parse((String)enchantmentDataComponent.enchantmentResourceLocation());
            String modNamespace = enchantmentResourceLocation.getNamespace();
            ModInfo modInfo = ModList.get().getModContainerById(modNamespace).map(ModContainer::getModInfo).orElse(null);
            if (modInfo != null) {
                String modName = modInfo.getDisplayName();
                MutableComponent addedBy = Component.literal((String)("Added by " + modName)).withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC});
                tooltipComponents.add((Component)addedBy);
            }
        }
    }
}

