/*
 * Decompiled with CFR 0.152.
 */
package me.alfie.immersiveenchanting.lootmodifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import me.alfie.immersiveenchanting.config.ImmersiveEnchantingConfig;
import me.alfie.immersiveenchanting.datacomponents.EnchantmentDataComponent;
import me.alfie.immersiveenchanting.datacomponents.ModDataComponents;
import me.alfie.immersiveenchanting.item.ModItems;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;

public class AncientBookLootModifier
extends LootModifier {
    public static final MapCodec<AncientBookLootModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)Codec.STRING.fieldOf("field1").forGetter(e -> e.field1), (App)Codec.INT.fieldOf("count").forGetter(e -> e.count), (App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("item").forGetter(e -> e.item), (App)Codec.FLOAT.fieldOf("chance").forGetter(e -> Float.valueOf(e.chance)))).apply((Applicative)inst, AncientBookLootModifier::new));
    private final String field1;
    private final int count;
    private final Item item;
    private final float chance;

    public AncientBookLootModifier(LootItemCondition[] conditions, String field1, int count, Item item, float chance) {
        super(conditions);
        this.field1 = field1;
        this.count = count;
        this.item = item;
        this.chance = chance;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (context.getRandom().nextFloat() < this.chance) {
            RegistryAccess registryAccess;
            HolderLookup.RegistryLookup lookup;
            List allEnchantments;
            List<Holder.Reference> filteredEnchantments;
            ItemStack lootItem = new ItemStack((ItemLike)this.item, this.count);
            if (lootItem.getItem() == ModItems.ANCIENT_BOOK.get() && !(filteredEnchantments = (allEnchantments = (lookup = (registryAccess = context.getLevel().registryAccess()).lookupOrThrow(Registries.ENCHANTMENT)).listElements().toList()).stream().filter(enchantment -> {
                ResourceLocation keyLocation = enchantment.key().location();
                if (keyLocation.equals((Object)ResourceLocation.parse((String)"minecraft:mending")) && !ImmersiveEnchantingConfig.isMendingEnabled()) {
                    return false;
                }
                return !enchantment.is(EnchantmentTags.CURSE);
            }).toList()).isEmpty()) {
                Holder.Reference randomEnchantment = filteredEnchantments.get(context.getRandom().nextInt(filteredEnchantments.size()));
                lootItem.set((DataComponentType)ModDataComponents.ENCHANTMENT.get(), (Object)new EnchantmentDataComponent(randomEnchantment.key().location().toString()));
            }
            generatedLoot.add((Object)lootItem);
        }
        return generatedLoot;
    }
}

