/*
 * Decompiled with CFR 0.152.
 */
package me.alfie.immersiveenchanting.networking;

import java.util.HashSet;
import java.util.List;
import me.alfie.immersiveenchanting.ImmersiveEnchanting;
import me.alfie.immersiveenchanting.gui.EnchantingTableMenu;
import me.alfie.immersiveenchanting.gui.EnchantingTableScreen;
import me.alfie.immersiveenchanting.networking.CheckBookshelfPacket;
import me.alfie.immersiveenchanting.networking.EnchantmentCostPacket;
import me.alfie.immersiveenchanting.networking.EnchantmentPacket;
import me.alfie.immersiveenchanting.networking.SerializedEnchantmentCostRegistry;
import me.alfie.immersiveenchanting.networking.SyncEnchantmentCostRegistryPacket;
import me.alfie.immersiveenchanting.networking.UnlockedEnchantmentsPacket;
import me.alfie.immersiveenchanting.networking.UpdateScrollableCanvas;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ClientPayloadHandler {
    public static void handleSyncEnchantmentCostRegistryPacket(SyncEnchantmentCostRegistryPacket packet, IPayloadContext context) {
        SerializedEnchantmentCostRegistry serializedRegistry = new SerializedEnchantmentCostRegistry(packet.enchantmentNamespaces(), packet.levels(), packet.items(), packet.amounts());
        ImmersiveEnchanting.clientEnchantmentCostRegistry = SyncEnchantmentCostRegistryPacket.deserialize(serializedRegistry);
    }

    public static void handleUpdateScrollableCanvasPacket(UpdateScrollableCanvas packet, IPayloadContext context) {
        Minecraft minecraft = Minecraft.getInstance();
        Screen screen = minecraft.screen;
        if (screen instanceof EnchantingTableScreen) {
            EnchantingTableScreen enchantingTableScreen = (EnchantingTableScreen)screen;
            enchantingTableScreen.buildScrollableCanvas(packet.highestEnchantmentLevel());
        }
    }

    public static void handleUnlockedEnchantmentPacket(UnlockedEnchantmentsPacket packet, IPayloadContext context) {
        List<String> resourceLocations = packet.enchantments();
        HashSet<String> unlockedEnchantments = new HashSet<String>(resourceLocations);
        AbstractContainerMenu abstractContainerMenu = context.player().containerMenu;
        if (abstractContainerMenu instanceof EnchantingTableMenu) {
            EnchantingTableMenu menu = (EnchantingTableMenu)abstractContainerMenu;
            menu.setUnlockedEnchantments(unlockedEnchantments);
        }
    }

    public static void handleEnchantmentCostPacket(EnchantmentCostPacket packet, IPayloadContext iPayloadContext) {
        ResourceLocation resourceLocation = ResourceLocation.tryParse((String)packet.itemId());
        Item item = (Item)BuiltInRegistries.ITEM.get(resourceLocation);
        ItemStack costStack = new ItemStack((ItemLike)item, packet.itemCount());
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof EnchantingTableScreen) {
            EnchantingTableScreen screen2 = (EnchantingTableScreen)screen;
            screen2.setRenderCostTo(costStack);
        }
    }

    public static void handleEnchantmentPacket(EnchantmentPacket packet, IPayloadContext context) {
    }

    public static void handleCheckBookshelfPacket(CheckBookshelfPacket packet, IPayloadContext context) {
    }
}

