/*
 * Decompiled with CFR 0.152.
 */
package me.alfie.immersiveenchanting.networking;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import me.alfie.immersiveenchanting.ImmersiveEnchanting;
import me.alfie.immersiveenchanting.block.CreativeBookshelf;
import me.alfie.immersiveenchanting.datacomponents.EnchantmentDataComponent;
import me.alfie.immersiveenchanting.datacomponents.ModDataComponents;
import me.alfie.immersiveenchanting.item.ModItems;
import me.alfie.immersiveenchanting.networking.CheckBookshelfPacket;
import me.alfie.immersiveenchanting.networking.EnchantmentCostPacket;
import me.alfie.immersiveenchanting.networking.EnchantmentPacket;
import me.alfie.immersiveenchanting.networking.SyncEnchantmentCostRegistryPacket;
import me.alfie.immersiveenchanting.networking.UnlockedEnchantmentsPacket;
import me.alfie.immersiveenchanting.networking.UpdateScrollableCanvas;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChiseledBookShelfBlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ServerPayloadHandler {
    public static void handleSyncEnchantmentCostRegistryPacket(SyncEnchantmentCostRegistryPacket packet, IPayloadContext context) {
    }

    public static void handleUpdateScrollableCanvasPacket(UpdateScrollableCanvas packet, IPayloadContext context) {
        int highestEnchantmentLevel = ImmersiveEnchanting.serverEnchantmentCostRegistry.getHighestEnchantmentLevel();
        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)context.player()), (CustomPacketPayload)new UpdateScrollableCanvas(highestEnchantmentLevel), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void handleEnchantmentPacket(EnchantmentPacket packet, IPayloadContext context) {
        boolean hasEnoughCost;
        Player player = context.player();
        if (player == null) {
            return;
        }
        AbstractContainerMenu menu = player.containerMenu;
        ItemStack item = menu.getSlot(packet.slotIndex()).getItem();
        RegistryAccess registryAccess = player.registryAccess();
        HolderLookup.RegistryLookup lookup = registryAccess.lookupOrThrow(Registries.ENCHANTMENT);
        Optional<Holder.Reference<Enchantment>> optionalHolder = ImmersiveEnchanting.getEnchantmentHolder((HolderLookup<Enchantment>)lookup, packet.enchantmentNamespace());
        Holder enchantment = (Holder)optionalHolder.orElseThrow(() -> new IllegalStateException("Enchantment not found: " + packet.enchantmentNamespace()));
        Level level = player.level();
        ItemStack slot2Item = menu.getSlot(2).getItem();
        ItemStack costItemStack = ImmersiveEnchanting.serverEnchantmentCostRegistry.getEnchantmentCost(ResourceLocation.parse((String)packet.enchantmentNamespace())).getLevel(packet.enchantmentLevel()).asItemStack();
        boolean bl = hasEnoughCost = menu.getSlot(1).getItem().is(Items.LAPIS_LAZULI) && (costItemStack.isEmpty() || slot2Item.is(costItemStack.getItem()) && slot2Item.getCount() >= costItemStack.getCount());
        if (hasEnoughCost) {
            menu.getSlot(1).getItem().shrink(1);
            if (!costItemStack.isEmpty()) {
                slot2Item.shrink(costItemStack.getCount());
            }
            item.enchant(enchantment, packet.enchantmentLevel());
            if (packet.enchantmentLevel() == ImmersiveEnchanting.serverEnchantmentCostRegistry.getEnchantmentCost(ResourceLocation.parse((String)packet.enchantmentNamespace())).getHighestLevel()) {
                level.playSound(null, player.blockPosition(), SoundEvents.BEACON_POWER_SELECT, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                level.playSound(null, player.blockPosition(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        } else {
            level.playSound(null, player.blockPosition(), SoundEvents.VILLAGER_NO, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public static void handleCheckBookshelfPacket(CheckBookshelfPacket packet, IPayloadContext context) {
        BlockPos tablePos = new BlockPos(packet.blockPosX(), packet.blockPosY(), packet.blockPosZ());
        ServerPayloadHandler.checkBookshelvesAndUpdateClient(tablePos, context.player().level(), (ServerPlayer)context.player());
    }

    @Nullable
    public static String getAncientBookType(ItemStack book) {
        if (book.has(ModDataComponents.ENCHANTMENT)) {
            return EnchantmentDataComponent.getEnchantmentData(book);
        }
        return null;
    }

    public static void checkBookshelvesAndUpdateClient(BlockPos tablePos, Level level, ServerPlayer serverPlayer) {
        List<BlockEntity> bookshelves = ServerPayloadHandler.getBookshelvesNearby(tablePos, level);
        List<String> unlockedEnchantmentNamespaces = new ArrayList<String>();
        for (BlockEntity bookshelf : bookshelves) {
            List<ItemStack> books = ServerPayloadHandler.getChiselledBookshelfContents(bookshelf);
            for (ItemStack book : books) {
                if (book.getItem() != ModItems.ANCIENT_BOOK.get()) continue;
                unlockedEnchantmentNamespaces.add(ServerPayloadHandler.getAncientBookType(book));
            }
        }
        if (ServerPayloadHandler.isCreativeBookshelfNearby(tablePos, level)) {
            unlockedEnchantmentNamespaces.clear();
            RegistryAccess registryAccess = level.registryAccess();
            HolderLookup.RegistryLookup lookup = registryAccess.lookupOrThrow(Registries.ENCHANTMENT);
            List allEnchantments = lookup.listElements().toList();
            unlockedEnchantmentNamespaces = allEnchantments.stream().map(holder -> holder.key().location().toString()).toList();
        }
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new UnlockedEnchantmentsPacket(unlockedEnchantmentNamespaces), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static List<ItemStack> getChiselledBookshelfContents(BlockEntity shelf) {
        ArrayList<ItemStack> contents = new ArrayList<ItemStack>();
        if (shelf instanceof ChiseledBookShelfBlockEntity) {
            for (int i = 0; i < 6; ++i) {
                ItemStack stack = ((ChiseledBookShelfBlockEntity)shelf).getItem(i);
                contents.add(stack);
            }
        }
        return contents;
    }

    private static List<BlockEntity> getBookshelvesNearby(BlockPos pos, Level level) {
        ArrayList<BlockEntity> blockEntities = new ArrayList<BlockEntity>();
        for (int dy = 0; dy <= 1; ++dy) {
            for (int dx = -2; dx <= 2; ++dx) {
                for (int dz = -2; dz <= 2; ++dz) {
                    BlockPos checkPos;
                    BlockEntity blockEntity;
                    if (Math.abs(dx) < 2 && Math.abs(dz) < 2 || !((blockEntity = level.getBlockEntity(checkPos = pos.offset(dx, dy, dz))) instanceof ChiseledBookShelfBlockEntity)) continue;
                    blockEntities.add(blockEntity);
                }
            }
        }
        return blockEntities;
    }

    private static boolean isCreativeBookshelfNearby(BlockPos pos, Level level) {
        for (int dy = 0; dy <= 1; ++dy) {
            for (int dx = -2; dx <= 2; ++dx) {
                for (int dz = -2; dz <= 2; ++dz) {
                    BlockPos checkPos;
                    if (Math.abs(dx) < 2 && Math.abs(dz) < 2 || !(level.getBlockState(checkPos = pos.offset(dx, dy, dz)).getBlock() instanceof CreativeBookshelf)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void handleUnlockedEnchantmentPacket(UnlockedEnchantmentsPacket packet, IPayloadContext context) {
    }

    public static void handleEnchantmentCostPacket(EnchantmentCostPacket packet, IPayloadContext iPayloadContext) {
        ItemStack itemCost = ImmersiveEnchanting.serverEnchantmentCostRegistry.getEnchantmentCost(ResourceLocation.tryParse((String)packet.enchantmentNamespace())).getLevel(packet.level()).asItemStack();
        String itemId = itemCost.getItem().toString();
        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)iPayloadContext.player()), (CustomPacketPayload)new EnchantmentCostPacket(packet.enchantmentNamespace(), packet.level(), itemId, itemCost.getCount()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

