/*
 * Decompiled with CFR 0.152.
 */
package me.alfie.immersiveenchanting.networking;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.alfie.immersiveenchanting.ImmersiveEnchanting;
import me.alfie.immersiveenchanting.datapack.EnchantmentCost;
import me.alfie.immersiveenchanting.datapack.EnchantmentCostRegistry;
import me.alfie.immersiveenchanting.datapack.LevelCost;
import me.alfie.immersiveenchanting.networking.ClientPayloadHandler;
import me.alfie.immersiveenchanting.networking.SerializedEnchantmentCostRegistry;
import me.alfie.immersiveenchanting.networking.ServerPayloadHandler;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.DirectionalPayloadHandler;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public record SyncEnchantmentCostRegistryPacket(List<String> enchantmentNamespaces, List<String> levels, List<String> items, List<Integer> amounts) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncEnchantmentCostRegistryPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"immersiveenchanting", (String)"sync_enchantment_cost_registry_packet"));
    public static final StreamCodec<ByteBuf, SyncEnchantmentCostRegistryPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.collection(ArrayList::new, (StreamCodec)ByteBufCodecs.STRING_UTF8), SyncEnchantmentCostRegistryPacket::enchantmentNamespaces, (StreamCodec)ByteBufCodecs.collection(ArrayList::new, (StreamCodec)ByteBufCodecs.STRING_UTF8), SyncEnchantmentCostRegistryPacket::levels, (StreamCodec)ByteBufCodecs.collection(ArrayList::new, (StreamCodec)ByteBufCodecs.STRING_UTF8), SyncEnchantmentCostRegistryPacket::items, (StreamCodec)ByteBufCodecs.collection(ArrayList::new, (StreamCodec)ByteBufCodecs.VAR_INT), SyncEnchantmentCostRegistryPacket::amounts, SyncEnchantmentCostRegistryPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static SerializedEnchantmentCostRegistry serialize(EnchantmentCostRegistry costRegistry) {
        ArrayList<String> enchantmentNamespaces = new ArrayList<String>();
        ArrayList<String> levels = new ArrayList<String>();
        ArrayList<String> itemNamespaces = new ArrayList<String>();
        ArrayList<Integer> amounts = new ArrayList<Integer>();
        for (Map.Entry<ResourceLocation, EnchantmentCost> registryEntry : costRegistry.getCostRegistry().entrySet()) {
            ResourceLocation enchantmentResourceLocation = registryEntry.getKey();
            EnchantmentCost cost = registryEntry.getValue();
            for (Map.Entry<String, LevelCost> costEntry : cost.levels.entrySet()) {
                String level = costEntry.getKey();
                LevelCost levelCost = costEntry.getValue();
                String itemNamespace = levelCost.item();
                int amount = levelCost.amount();
                enchantmentNamespaces.add(enchantmentResourceLocation.toString());
                levels.add(level);
                itemNamespaces.add(itemNamespace);
                amounts.add(amount);
            }
        }
        return new SerializedEnchantmentCostRegistry(enchantmentNamespaces, levels, itemNamespaces, amounts);
    }

    public static EnchantmentCostRegistry deserialize(SerializedEnchantmentCostRegistry serializedRegistry) {
        EnchantmentCostRegistry enchantmentCostRegistry = new EnchantmentCostRegistry();
        for (int i = 0; i < serializedRegistry.enchantmentNamespaces().size(); ++i) {
            ResourceLocation enchantmentResourceLocation = ResourceLocation.parse((String)serializedRegistry.enchantmentNamespaces().get(i));
            String level = serializedRegistry.levels().get(i);
            String item = serializedRegistry.itemNamespaces().get(i);
            int amount = serializedRegistry.amounts().get(i);
            LevelCost levelCost = new LevelCost(item, amount);
            EnchantmentCost enchantmentCost = enchantmentCostRegistry.getCostRegistry().computeIfAbsent(enchantmentResourceLocation, k -> new EnchantmentCost());
            enchantmentCost.levels.put(level, levelCost);
        }
        return enchantmentCostRegistry;
    }

    public static void syncClientWithServer(ServerPlayer player) {
        if (player.level().isClientSide) {
            return;
        }
        SerializedEnchantmentCostRegistry serializedRegistry = SyncEnchantmentCostRegistryPacket.serialize(ImmersiveEnchanting.serverEnchantmentCostRegistry);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncEnchantmentCostRegistryPacket(serializedRegistry.enchantmentNamespaces(), serializedRegistry.levels(), serializedRegistry.itemNamespaces(), serializedRegistry.amounts()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playBidirectional(TYPE, STREAM_CODEC, (IPayloadHandler)new DirectionalPayloadHandler(ClientPayloadHandler::handleSyncEnchantmentCostRegistryPacket, ServerPayloadHandler::handleSyncEnchantmentCostRegistryPacket));
    }
}

