/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.reskillable.client;

import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import io.redspace.ironsspellbooks.item.Scroll;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import net.bandit.reskillable.Configuration;
import net.bandit.reskillable.common.capabilities.SkillModel;
import net.bandit.reskillable.common.commands.skills.Requirement;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

public class Tooltip {
    private static final Logger LOGGER = Logger.getLogger(Tooltip.class.getName());
    private boolean isTaczLoaded = ModList.get().isLoaded("tacz");
    private boolean isIronsLoaded = ModList.get().isLoaded("irons_spellbooks");

    @SubscribeEvent
    public void onTooltipDisplay(ItemTooltipEvent event) {
        ItemStack stack;
        ResourceLocation itemRegistryName;
        if (Minecraft.getInstance().player != null && (itemRegistryName = BuiltInRegistries.ITEM.getKey((Object)(stack = event.getItemStack()).getItem())) != null) {
            Requirement[] requirements;
            AbstractSpell spell;
            String[] split;
            SpellData spellAtIndex;
            CompoundTag tag;
            if (this.isTaczLoaded && Objects.equals(itemRegistryName.getNamespace(), "tacz") && (tag = (CompoundTag)stack.getTags()) != null && tag.contains("GunId")) {
                itemRegistryName = ResourceLocation.fromNamespaceAndPath((String)"tacz", (String)"%s__%s".formatted(itemRegistryName.getPath(), tag.getString("GunId").replaceAll(":", "_")));
            }
            if (this.isIronsLoaded && stack.getItem() instanceof Scroll && (spellAtIndex = ISpellContainer.get((ItemStack)stack).getSpellAtIndex(0)) != null && spellAtIndex.getSpell() != null && (split = (spell = spellAtIndex.getSpell()).getSpellId().split(":")).length == 2) {
                itemRegistryName = ResourceLocation.fromNamespaceAndPath((String)"irons_spellbooks", (String)"scroll__%s_%d".formatted(split[1], spellAtIndex.getLevel()));
            }
            if ((requirements = Configuration.getRequirements(itemRegistryName)) != null) {
                List tooltips = event.getToolTip();
                tooltips.add(Component.literal((String)""));
                tooltips.add(Component.translatable((String)"tooltip.requirements").append(":").withStyle(ChatFormatting.GRAY));
                SkillModel skillModel = SkillModel.get((Player)Minecraft.getInstance().player);
                for (Requirement requirement : requirements) {
                    ChatFormatting colour = skillModel.getSkillLevel(requirement.skill) >= requirement.level ? ChatFormatting.GREEN : ChatFormatting.RED;
                    tooltips.add(Component.translatable((String)requirement.skill.displayName).append(" " + requirement.level).withStyle(colour));
                }
            }
        }
    }
}

