/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.reskillable.client.screen.buttons;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.bandit.reskillable.Configuration;
import net.bandit.reskillable.client.screen.SkillScreen;
import net.bandit.reskillable.common.capabilities.SkillModel;
import net.bandit.reskillable.common.commands.skills.Skill;
import net.bandit.reskillable.common.commands.skills.SkillAttributeBonus;
import net.bandit.reskillable.common.network.payload.RequestLevelUp;
import net.bandit.reskillable.common.network.payload.TogglePerk;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class SkillButton
extends Button {
    private final Skill skill;
    private List<Component> tooltipLines = List.of();

    public SkillButton(int x, int y, Skill skill) {
        super(new Button.Builder((Component)Component.literal((String)""), onPress -> RequestLevelUp.send(skill)).pos(x, y).size(79, 32));
        this.skill = skill;
    }

    public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft == null || minecraft.player == null) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        LocalPlayer clientPlayer = minecraft.player;
        Font font = minecraft.font;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)SkillScreen.RESOURCES);
        SkillModel skillModel = SkillModel.get((Player)clientPlayer);
        if (skillModel == null) {
            return;
        }
        int level = skillModel.getSkillLevel(this.skill);
        int maxLevel = Configuration.getMaxLevel();
        int u = ((int)Math.ceil((double)level * 4.0 / (double)maxLevel) - 1) * 16 + 176;
        int v = this.skill.index * 16 + 128;
        guiGraphics.blit(SkillScreen.RESOURCES, this.getX(), this.getY(), 176, (level == maxLevel ? 64 : 0) + (this.isMouseOver(mouseX, mouseY) ? 32 : 0), this.width, this.height);
        guiGraphics.blit(SkillScreen.RESOURCES, this.getX() + 6, this.getY() + 8, u, v, 16, 16);
        if (!skillModel.isPerkEnabled(this.skill) && SkillAttributeBonus.getBySkill(this.skill) != null) {
            int iconX = this.getX() + this.width - 10;
            int iconY = this.getY() + this.height - 10;
            guiGraphics.drawString(font, "\u2716", iconX, iconY, 0xFF5555, false);
        }
        guiGraphics.drawString(font, (Component)Component.translatable((String)this.skill.getDisplayName()), this.getX() + 25, this.getY() + 7, 0xFFFFFF, false);
        guiGraphics.drawString(font, (Component)Component.literal((String)(level + "/" + maxLevel)), this.getX() + 25, this.getY() + 18, 0xBEBEBE, false);
        this.tooltipLines = this.isMouseOver(mouseX, mouseY) ? this.getTooltipLines((Player)clientPlayer) : List.of();
    }

    public void updateWidgetNarration(@NotNull NarrationElementOutput output) {
        this.defaultButtonNarrationText(output);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!(this.active && this.visible && this.isMouseOver(mouseX, mouseY))) {
            return false;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return false;
        }
        SkillModel model = SkillModel.get((Player)player);
        if (model == null) {
            return false;
        }
        if (button == 1) {
            if (SkillAttributeBonus.getBySkill(this.skill) != null) {
                TogglePerk.send(this.skill);
                player.playSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 0.6f, 1.0f);
            }
        } else if (button == 0) {
            RequestLevelUp.send(this.skill);
        }
        return true;
    }

    public List<Component> getTooltipLines(Player player) {
        SkillModel model = SkillModel.get(player);
        if (model == null) {
            return List.of();
        }
        ArrayList<Component> lines = new ArrayList<Component>();
        int level = model.getSkillLevel(this.skill);
        int cost = Configuration.calculateCostForLevel(level);
        int playerXP = this.getPlayerTotalXP(player);
        MutableComponent xp = Component.literal((String)String.valueOf(playerXP)).withStyle(playerXP >= cost ? ChatFormatting.GREEN : ChatFormatting.RED);
        MutableComponent costC = Component.literal((String)String.valueOf(cost));
        lines.add((Component)Component.translatable((String)"tooltip.rereskillable.skill_cost", (Object[])new Object[]{xp, costC}));
        if (SkillAttributeBonus.getBySkill(this.skill) != null) {
            boolean enabled = model.isPerkEnabled(this.skill);
            lines.add((Component)Component.literal((String)"\u27a4 ").append((Component)Component.literal((String)"Right-click: ").withStyle(ChatFormatting.GOLD)).append((Component)Component.literal((String)(enabled ? "Disable skill perk" : "Enable skill perk")).withStyle(enabled ? ChatFormatting.RED : ChatFormatting.GREEN)));
        }
        lines.add((Component)Component.literal((String)"\u27a4 ").append((Component)Component.literal((String)"Left-click: ").withStyle(ChatFormatting.GOLD)).append((Component)Component.literal((String)"Level up this skill").withStyle(ChatFormatting.AQUA)));
        return lines;
    }

    private int getPlayerTotalXP(Player player) {
        int level = player.experienceLevel;
        float progress = player.experienceProgress;
        if (level <= 16) {
            return level * level + 6 * level + Math.round(progress * (float)(2 * level + 7));
        }
        if (level <= 31) {
            return (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0) + Math.round(progress * (float)(5 * level - 38));
        }
        return (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0) + Math.round(progress * (float)(9 * level - 158));
    }

    public List<Component> getCurrentTooltipLines() {
        return this.tooltipLines;
    }
}

