/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.reskillable.client.screen.buttons;

import net.bandit.reskillable.client.screen.SkillScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class TabButton
extends AbstractWidget {
    private final boolean selected;
    private final TabType type;

    public TabButton(int x, int y, TabType type, boolean selected) {
        super(x, y, 31, 28, (Component)Component.literal((String)"Skill"));
        this.type = type;
        this.selected = selected;
    }

    public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        Minecraft minecraft = Minecraft.getInstance();
        boolean bl = this.active = !(minecraft.screen instanceof InventoryScreen) || !((InventoryScreen)minecraft.screen).getRecipeBookComponent().isVisible();
        if (this.active) {
            Screen screen = minecraft.screen;
            if (screen instanceof InventoryScreen) {
                InventoryScreen inventoryScreen = (InventoryScreen)screen;
                int guiLeft = inventoryScreen.getGuiLeft();
                int guiTop = inventoryScreen.getGuiTop();
                this.setPosition(guiLeft - 28, guiTop + (this.type == TabType.INVENTORY ? 7 : 36));
            }
            guiGraphics.blit(SkillScreen.RESOURCES, this.getX(), this.getY(), this.selected ? 31 : 0, 166, this.width, this.height);
            guiGraphics.blit(SkillScreen.RESOURCES, this.getX() + (this.selected ? 8 : 10), this.getY() + 6, 240, 128 + this.type.iconIndex * 16, 16, 16);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOver(mouseX, mouseY) && this.active) {
            this.onPress();
            return true;
        }
        return false;
    }

    public void onPress() {
        Minecraft minecraft = Minecraft.getInstance();
        switch (this.type.ordinal()) {
            case 0: {
                if (minecraft.player == null) break;
                minecraft.setScreen((Screen)new InventoryScreen((Player)minecraft.player));
                break;
            }
            case 1: {
                minecraft.setScreen((Screen)new SkillScreen());
            }
        }
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput output) {
        this.defaultButtonNarrationText(output);
    }

    public static enum TabType {
        INVENTORY(0),
        SKILLS(1);

        public final int iconIndex;

        private TabType(int index) {
            this.iconIndex = index;
        }
    }
}

