/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.reskillable.common;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.bandit.reskillable.Configuration;
import net.bandit.reskillable.common.capabilities.SkillModel;
import net.bandit.reskillable.common.commands.skills.Requirement;
import net.bandit.reskillable.common.commands.skills.Skill;
import net.bandit.reskillable.common.commands.skills.SkillAttributeBonus;
import net.bandit.reskillable.common.network.payload.SyncToClient;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import net.neoforged.neoforge.event.entity.living.LivingUseTotemEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.entity.player.PlayerXpEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.block.CropGrowEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class EventHandler {
    private static final Map<UUID, SkillModel> lastDiedPlayerSkillsMap = new ConcurrentHashMap<UUID, SkillModel>();

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        SkillModel model = SkillModel.get(player);
        if (model == null) {
            return;
        }
        ItemStack item = event.getItemStack();
        Block block = event.getLevel().getBlockState(event.getPos()).getBlock();
        if (!(player.isCreative() || model.canUseItem(player, item) && model.canUseBlock(player, block))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onStartUsingItem(LivingEntityUseItemEvent.Start event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        SkillModel model = SkillModel.get(player);
        if (model == null || player.isCreative()) {
            return;
        }
        ItemStack item = event.getItem();
        if (!model.canUseItem(player, item)) {
            event.setCanceled(true);
            player.sendSystemMessage((Component)Component.literal((String)"You lack the skill to use this item.").withStyle(ChatFormatting.RED));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        SkillModel model = SkillModel.get(player);
        if (model == null) {
            return;
        }
        ItemStack item = event.getItemStack();
        Block block = event.getLevel().getBlockState(event.getPos()).getBlock();
        if (!(player.isCreative() || model.canUseItem(player, item) && model.canUseBlock(player, block))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        SkillModel model = SkillModel.get(player);
        if (model == null) {
            return;
        }
        ItemStack item = event.getItemStack();
        if (!player.isCreative() && !model.canUseItem(player, item)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getEntity();
        SkillModel model = SkillModel.get(player);
        if (model == null) {
            return;
        }
        Entity entity = event.getTarget();
        ItemStack item = event.getItemStack();
        if (!(player.isCreative() || model.canUseEntity(player, entity) && model.canUseItem(player, item))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onAttackEntity(AttackEntityEvent event) {
        Player player = event.getEntity();
        SkillModel model = SkillModel.get(player);
        if (model == null || player.isCreative()) {
            return;
        }
        ItemStack mainHand = player.getMainHandItem();
        ItemStack offHand = player.getOffhandItem();
        boolean canUseMain = model.canUseItem(player, mainHand);
        boolean canUseOff = model.canUseItem(player, offHand);
        if (!(canUseMain && canUseOff && model.canAttackEntity(player, event.getTarget()))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onChangeEquipment(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        SkillModel model = SkillModel.get(player);
        if (model == null || player.isCreative()) {
            return;
        }
        if (event.getSlot().getType() == EquipmentSlot.Type.HUMANOID_ARMOR) {
            ItemStack newItem = event.getTo();
            ItemStack oldItem = event.getFrom();
            if (!model.canUseItem(player, newItem)) {
                player.setItemSlot(event.getSlot(), oldItem);
                player.drop(newItem.copy(), false);
                player.sendSystemMessage((Component)Component.literal((String)"You lack the skill to equip this armor.").withStyle(ChatFormatting.RED));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityDrops(LivingDropsEvent event) {
        if (Configuration.getDisableWool() && event.getEntity() instanceof Sheep) {
            event.getDrops().removeIf(item -> item.getItem().is(ItemTags.WOOL));
        }
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && !(player = (Player)livingEntity).level().isClientSide()) {
            SkillModel model = SkillModel.get(player);
            if (model == null) {
                return;
            }
            if (Configuration.getDeathReset() && !lastDiedPlayerSkillsMap.containsKey(player.getUUID())) {
                model.resetSkills();
            }
            lastDiedPlayerSkillsMap.put(player.getUUID(), model);
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            return;
        }
        SkillModel oldModel = SkillModel.get(event.getOriginal());
        SkillModel newModel = SkillModel.get(event.getEntity());
        if (oldModel != null && newModel != null) {
            newModel.cloneFrom(oldModel);
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        SkillModel model = SkillModel.get((Player)player);
        if (model != null) {
            SyncToClient.send(player);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onUseItemStart(LivingEntityUseItemEvent.Start event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        SkillModel model = SkillModel.get(player);
        if (model == null || player.isCreative()) {
            return;
        }
        ItemStack item = event.getItem();
        if (!model.canUseItem(player, item)) {
            player.sendSystemMessage((Component)Component.literal((String)"You lack the skill to use this item.").withStyle(ChatFormatting.RED));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        SkillModel model = SkillModel.get(player);
        if (model == null || player.isCreative()) {
            return;
        }
        ItemStack tool = player.getMainHandItem();
        if (!model.canUseItem(player, tool)) {
            event.setCanceled(true);
            player.sendSystemMessage((Component)Component.literal((String)"You lack the skill to use this tool.").withStyle(ChatFormatting.RED));
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        ServerPlayer serverPlayer;
        SkillModel model;
        Player player = event.getEntity();
        if (!player.level().isClientSide() && player instanceof ServerPlayer && (model = SkillModel.get((Player)(serverPlayer = (ServerPlayer)player))) != null) {
            SyncToClient.send(serverPlayer);
            model.updateSkillAttributeBonuses((Player)serverPlayer);
        }
    }

    @SubscribeEvent
    public void onChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        ServerPlayer serverPlayer;
        SkillModel model;
        Player player = event.getEntity();
        if (!player.level().isClientSide() && player instanceof ServerPlayer && (model = SkillModel.get((Player)(serverPlayer = (ServerPlayer)player))) != null) {
            model.syncSkills((Player)serverPlayer);
            model.updateSkillAttributeBonuses((Player)serverPlayer);
        }
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        SkillAttributeBonus bonus;
        int miningLevel;
        Player player = event.getEntity();
        SkillModel model = SkillModel.get(player);
        if (model != null && (miningLevel = model.getSkillLevel(Skill.MINING)) >= 5 && (bonus = SkillAttributeBonus.getBySkill(Skill.MINING)) != null && model.isPerkEnabled(Skill.MINING)) {
            float multiplier = 1.0f + (float)miningLevel / 5.0f * (float)bonus.getBonusPerStep();
            event.setNewSpeed(event.getNewSpeed() * multiplier);
        }
    }

    @SubscribeEvent
    public void onCropGrow(CropGrowEvent.Pre event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        level.players().forEach(player -> {
            SkillModel model;
            if (player.distanceToSqr(Vec3.atCenterOf((Vec3i)event.getPos())) < 64.0 && (model = SkillModel.get((Player)player)) != null) {
                int farmingLevel = model.getSkillLevel(Skill.FARMING);
                SkillAttributeBonus bonus = SkillAttributeBonus.getBySkill(Skill.FARMING);
                if (bonus != null && model.isPerkEnabled(Skill.FARMING)) {
                    float chance = (float)farmingLevel / 5.0f * (float)bonus.getBonusPerStep();
                    if (farmingLevel >= 5 && level.random.nextFloat() < chance) {
                        event.setResult(CropGrowEvent.Pre.Result.GROW);
                    }
                }
            }
        });
    }

    @SubscribeEvent
    public void onXpPickup(PlayerXpEvent.PickupXp event) {
        double bonusPercentPerStep;
        int bonusSteps;
        float originalXp;
        int bonusXp;
        Player player = event.getEntity();
        if (player.level().isClientSide) {
            return;
        }
        SkillModel model = SkillModel.get(player);
        if (model == null || !model.isPerkEnabled(Skill.GATHERING)) {
            return;
        }
        int gatheringLevel = model.getSkillLevel(Skill.GATHERING);
        if (gatheringLevel < 5) {
            return;
        }
        SkillAttributeBonus bonus = SkillAttributeBonus.getBySkill(Skill.GATHERING);
        if (bonus != null && (bonusXp = Math.round((originalXp = (float)event.getOrb().value) * (float)((double)(bonusSteps = gatheringLevel / 5) * (bonusPercentPerStep = bonus.getBonusPerStep())))) > 0) {
            player.giveExperiencePoints(bonusXp);
        }
    }

    @SubscribeEvent
    public void onPlayerEquipmentChange(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        SkillModel model = SkillModel.get(player);
        if (model == null || player.level().isClientSide) {
            return;
        }
        model.updateSkillAttributeBonuses(player);
    }

    @SubscribeEvent
    public void onPlayerTickAgility(PlayerTickEvent.Post event) {
        double multiplier;
        Player player = event.getEntity();
        SkillModel model = SkillModel.get(player);
        if (model == null) {
            return;
        }
        AttributeInstance attribute = player.getAttributes().getInstance(Attributes.MOVEMENT_SPEED);
        if (attribute == null) {
            return;
        }
        SkillAttributeBonus bonus = SkillAttributeBonus.getBySkill(Skill.AGILITY);
        if (bonus == null) {
            return;
        }
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"reskillable", (String)"agility");
        attribute.getModifiers().stream().filter(mod -> mod.id().equals((Object)id)).findFirst().ifPresent(arg_0 -> ((AttributeInstance)attribute).removeModifier(arg_0));
        int agilityLevel = model.getSkillLevel(Skill.AGILITY);
        if (agilityLevel >= 5 && model.isPerkEnabled(Skill.AGILITY) && (multiplier = (double)agilityLevel / 5.0 * bonus.getBonusPerStep()) > 0.0) {
            AttributeModifier mod2 = new AttributeModifier(id, multiplier, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            attribute.addTransientModifier(mod2);
        }
    }

    @SubscribeEvent
    public void onUseTotem(LivingUseTotemEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        ItemStack totem = event.getTotem();
        if (totem == null || totem.isEmpty()) {
            return;
        }
        if (!totem.is(Items.TOTEM_OF_UNDYING)) {
            return;
        }
        SkillModel model = SkillModel.get(player);
        if (model == null) {
            return;
        }
        ResourceKey keyOpt = totem.getItem().builtInRegistryHolder().key();
        if (keyOpt == null) {
            return;
        }
        ResourceLocation id = keyOpt.location();
        Requirement[] reqs = Configuration.getRequirements(id);
        if (reqs == null || reqs.length == 0) {
            return;
        }
        for (Requirement req : reqs) {
            if (req == null || model.getSkillLevel(req.skill) >= req.level) continue;
            event.setCanceled(true);
            player.sendSystemMessage((Component)Component.literal((String)"You lack the skill to use the Totem of Undying.").withStyle(ChatFormatting.RED));
            return;
        }
    }
}

