/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.reskillable.common;

import io.redspace.ironsspellbooks.api.events.SpellPreCastEvent;
import net.bandit.reskillable.common.AbsEventHandler;
import net.bandit.reskillable.common.capabilities.SkillModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.api.spell.container.SpellContainerHelper;

public class IronsSpellbooksEventHandler
extends AbsEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onSpellCastEvent(SpellPreCastEvent event) {
        Player player = event.getEntity();
        if (player.isCreative()) {
            return;
        }
        SkillModel model = SkillModel.get(player);
        if (model == null) {
            return;
        }
        String spellId = event.getSpellId();
        String[] split = spellId.split(":");
        if (split.length == 2) {
            ResourceLocation ironsSpellbooks = ResourceLocation.fromNamespaceAndPath((String)"irons_spellbooks", (String)"scroll__%s_%d".formatted(split[1], event.getSpellLevel()));
            if (!IronsSpellbooksEventHandler.checkRequirements(model, player, ironsSpellbooks)) {
                event.setCanceled(true);
            }
        } else {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRightClickWizardsItem(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        if (player.isCreative()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.isEmpty()) {
            return;
        }
        SpellContainer container = SpellContainerHelper.containerFromItemStack((ItemStack)stack);
        if (container == null) {
            return;
        }
        SkillModel model = SkillModel.get(player);
        if (model == null) {
            return;
        }
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        if (id == null) {
            return;
        }
        if (!IronsSpellbooksEventHandler.checkRequirements(model, player, id)) {
            event.setCanceled(true);
            player.displayClientMessage((Component)Component.translatable((String)"reskillable.requirement.not_met"), true);
        }
    }
}

