/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.reskillable.common.capabilities;

import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.bandit.reskillable.Configuration;
import net.bandit.reskillable.common.commands.skills.Requirement;
import net.bandit.reskillable.common.commands.skills.RequirementType;
import net.bandit.reskillable.common.commands.skills.Skill;
import net.bandit.reskillable.common.commands.skills.SkillAttributeBonus;
import net.bandit.reskillable.common.network.payload.SyncToClient;
import net.bandit.reskillable.event.SkillAttachments;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.UnknownNullability;

public class SkillModel
implements INBTSerializable<CompoundTag> {
    private static final int DEFAULT_SKILL_COUNT = 8;
    private int[] skillLevels = new int[8];
    private int[] skillExperience = new int[8];
    private final Set<Skill> disabledPerks = new HashSet<Skill>();
    private static final UUID GLOBAL_HEALTH_BONUS_ID = UUID.nameUUIDFromBytes("reskillable:global_health_bonus".getBytes());
    private static final UUID[] ATTRIBUTE_MODIFIER_IDS = new UUID[Skill.values().length];

    public SkillModel() {
        this.resetSkills();
    }

    public int getSkillLevel(Skill skill) {
        return this.skillLevels[skill.index];
    }

    public void setSkillLevel(Skill skill, int level) {
        this.skillLevels[skill.index] = Math.min(level, Configuration.getMaxLevel());
    }

    public void increaseSkillLevel(Skill skill, Player player) {
        int currentLevel = this.skillLevels[skill.index];
        if (currentLevel < Configuration.getMaxLevel()) {
            int n = skill.index;
            this.skillLevels[n] = this.skillLevels[n] + 1;
            this.skillExperience[skill.index] = 0;
            this.updateSkillAttributeBonuses(player);
            this.syncSkills(player);
            this.updateSkillAttributeBonuses(player);
            int newLevel = this.skillLevels[skill.index];
            if (newLevel % 5 == 0) {
                SkillAttributeBonus bonus = SkillAttributeBonus.getBySkill(skill);
                Attribute attr = bonus.getAttribute();
                if (bonus != null && attr != null) {
                    double amount = bonus.getBonusPerStep();
                    String string = attr.getDescriptionId().replace("attribute.name.", "");
                }
            }
        }
    }

    public void addExperience(Skill skill, int experience) {
        int n = skill.index;
        this.skillExperience[n] = this.skillExperience[n] + experience;
        this.checkForLevelUp(skill);
    }

    private void checkForLevelUp(Skill skill) {
        int xp;
        int level = this.skillLevels[skill.index];
        for (xp = this.skillExperience[skill.index]; level < Configuration.getMaxLevel() && xp >= Configuration.calculateExperienceCost(level); xp -= Configuration.calculateExperienceCost(level), ++level) {
        }
        this.skillExperience[skill.index] = xp;
        this.skillLevels[skill.index] = level;
    }

    public boolean hasSufficientXP(Player player, Skill skill) {
        if (player.isCreative() || player.level().isClientSide) {
            return true;
        }
        int totalXP = this.calculateTotalXPFromPlayer(player);
        return totalXP >= Configuration.calculateCostForLevel(this.getSkillLevel(skill) + 1);
    }

    private int calculateTotalXPFromPlayer(Player player) {
        int level = player.experienceLevel;
        int progress = Math.round(player.experienceProgress * (float)Configuration.calculateExperienceCost(level));
        return Configuration.getCumulativeXpForLevel(level) + progress;
    }

    public boolean canUseItem(Player player, ItemStack item) {
        return this.canUse(player, item.getItem().builtInRegistryHolder().key().location());
    }

    public boolean canUseBlock(Player player, Block block) {
        return this.canUse(player, block.builtInRegistryHolder().key().location());
    }

    public boolean canUseEntity(Player player, Entity entity) {
        return this.canUse(player, entity.getType().builtInRegistryHolder().key().location());
    }

    private boolean canUse(Player player, ResourceLocation resource) {
        return this.checkRequirements(player, resource, RequirementType.USE);
    }

    private boolean checkRequirements(Player player, ResourceLocation resource, RequirementType type) {
        Requirement[] requirements = type.getRequirements(resource);
        if (requirements == null || requirements.length == 0) {
            return true;
        }
        ArrayList<Requirement> unmetRequirements = new ArrayList<Requirement>();
        for (Requirement requirement : requirements) {
            if (this.getSkillLevel(requirement.skill) >= requirement.level) continue;
            unmetRequirements.add(requirement);
        }
        if (!unmetRequirements.isEmpty()) {
            this.sendSkillRequirementMessage(player, type, unmetRequirements);
            return false;
        }
        return true;
    }

    private void sendSkillRequirementMessage(Player player, RequirementType type, List<Requirement> unmetRequirements) {
        String translationKey = switch (type) {
            default -> throw new MatchException(null, null);
            case RequirementType.ATTACK -> "message.reskillable.requirement.attack";
            case RequirementType.CRAFT -> "message.reskillable.requirement.craft";
            case RequirementType.USE -> "message.reskillable.requirement.use";
        };
        ArrayList<MutableComponent> formattedRequirements = new ArrayList<MutableComponent>();
        for (Requirement req : unmetRequirements) {
            String skillTranslationKey = "skill." + req.skill.name().toLowerCase();
            MutableComponent translatedSkillName = Component.translatable((String)skillTranslationKey);
            formattedRequirements.add(Component.literal((String)"").append((Component)translatedSkillName).append(" level " + req.level));
        }
        MutableComponent joinedRequirements = Component.literal((String)" ").append((Component)Component.literal((String)String.join((CharSequence)", ", formattedRequirements.stream().map(Component::getString).collect(Collectors.toList()))));
        MutableComponent message = Component.translatable((String)translationKey, (Object[])new Object[]{joinedRequirements});
        player.displayClientMessage((Component)message, true);
    }

    public static SkillModel get(Player player) {
        return (SkillModel)player.getData((AttachmentType)SkillAttachments.SKILL_MODEL.get());
    }

    public boolean canCraftItem(Player player, ItemStack stack) {
        ResourceLocation resource = stack.getItem().builtInRegistryHolder().key().location();
        return this.checkRequirements(player, resource, RequirementType.CRAFT);
    }

    public boolean canAttackEntity(Player player, Entity target) {
        ResourceLocation resource = target.getType().builtInRegistryHolder().key().location();
        return this.checkRequirements(player, resource, RequirementType.ATTACK);
    }

    public void syncSkills(Player player) {
        if (player instanceof ServerPlayer) {
            SyncToClient.send((ServerPlayer)player);
        }
    }

    public void resetSkills() {
        for (int i = 0; i < 8; ++i) {
            this.skillLevels[i] = 1;
            this.skillExperience[i] = 0;
        }
    }

    public void cloneFrom(SkillModel source) {
        this.skillLevels = (int[])source.skillLevels.clone();
        this.skillExperience = (int[])source.skillExperience.clone();
    }

    public void updateSkillAttributeBonuses(Player player) {
        for (SkillAttributeBonus bonus : SkillAttributeBonus.values()) {
            int skillLevel;
            int bonusSteps;
            double totalBonus;
            AttributeInstance attrInstance;
            Holder.Reference attr = BuiltInRegistries.ATTRIBUTE.getResourceKey((Object)bonus.getAttribute()).flatMap(arg_0 -> ((Registry)BuiltInRegistries.ATTRIBUTE).getHolder(arg_0)).orElse(null);
            if (attr == null || (attrInstance = player.getAttributes().getInstance((Holder)attr)) == null) continue;
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"reskillable", (String)bonus.skill.name().toLowerCase());
            attrInstance.getModifiers().stream().filter(mod -> mod.id().equals((Object)id)).findFirst().ifPresent(arg_0 -> ((AttributeInstance)attrInstance).removeModifier(arg_0));
            if (!this.isPerkEnabled(bonus.skill) || !((totalBonus = (double)(bonusSteps = (skillLevel = this.getSkillLevel(bonus.skill)) / 5) * bonus.getBonusPerStep()) > 0.0)) continue;
            AttributeModifier modifier = new AttributeModifier(id, totalBonus, AttributeModifier.Operation.ADD_VALUE);
            attrInstance.addTransientModifier(modifier);
        }
        this.handleHealthBonus(player);
    }

    private void handleHealthBonus(Player player) {
        if (!((Boolean)Configuration.HEALTH_BONUS.get()).booleanValue()) {
            return;
        }
        int totalSkillLevels = Arrays.stream(this.skillLevels).sum();
        int levelsPerHeart = (Integer)Configuration.LEVELS_PER_HEART.get();
        double healthPerHeart = (Double)Configuration.HEALTH_PER_HEART.get();
        int hearts = totalSkillLevels / levelsPerHeart;
        double healthBonus = (double)hearts * healthPerHeart;
        AttributeInstance healthAttr = player.getAttributes().getInstance(Attributes.MAX_HEALTH);
        if (healthAttr != null) {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"reskillable", (String)"health_bonus");
            healthAttr.getModifiers().stream().filter(mod -> mod.id().equals((Object)id)).findFirst().ifPresent(arg_0 -> ((AttributeInstance)healthAttr).removeModifier(arg_0));
            if (healthBonus > 0.0) {
                AttributeModifier healthModifier = new AttributeModifier(id, healthBonus, AttributeModifier.Operation.ADD_VALUE);
                healthAttr.addTransientModifier(healthModifier);
            }
        }
    }

    public boolean isPerkEnabled(Skill skill) {
        return !this.disabledPerks.contains((Object)skill);
    }

    public void togglePerk(Skill skill, Player player) {
        if (!this.disabledPerks.add(skill)) {
            this.disabledPerks.remove((Object)skill);
        }
        this.updateSkillAttributeBonuses(player);
        this.syncSkills(player);
    }

    public @UnknownNullability CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compound = new CompoundTag();
        compound.putIntArray("skillLevels", this.skillLevels);
        compound.putIntArray("skillExperience", this.skillExperience);
        List disabledSkillNames = this.disabledPerks.stream().map(skill -> skill.name()).collect(Collectors.toList());
        compound.putIntArray("skillLevels", this.skillLevels);
        compound.putIntArray("skillExperience", this.skillExperience);
        CompoundTag disabledTag = new CompoundTag();
        for (Skill skill2 : this.disabledPerks) {
            disabledTag.putBoolean(skill2.name(), true);
        }
        compound.put("disabledPerks", (Tag)disabledTag);
        return compound;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag compoundTag) {
        int[] loadedLevels = compoundTag.getIntArray("skillLevels");
        int[] loadedExperience = compoundTag.getIntArray("skillExperience");
        if (loadedLevels.length == 8) {
            this.skillLevels = loadedLevels;
        }
        if (loadedExperience.length == 8) {
            this.skillExperience = loadedExperience;
        }
        this.disabledPerks.clear();
        if (compoundTag.contains("disabledPerks", 10)) {
            CompoundTag disabledTag = compoundTag.getCompound("disabledPerks");
            for (String key : disabledTag.getAllKeys()) {
                try {
                    Skill skill = Skill.valueOf(key);
                    this.disabledPerks.add(skill);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
    }

    public void readFromNetwork(SyncToClient msg) {
        for (Map.Entry<Skill, Integer> entry : msg.levels().entrySet()) {
            this.skillLevels[entry.getKey().index] = entry.getValue();
        }
        this.disabledPerks.clear();
        for (Map.Entry<Skill, Constable> entry : msg.disabledPerks().entrySet()) {
            if (!((Boolean)entry.getValue()).booleanValue()) continue;
            this.disabledPerks.add(entry.getKey());
        }
    }

    static {
        for (int i = 0; i < ATTRIBUTE_MODIFIER_IDS.length; ++i) {
            SkillModel.ATTRIBUTE_MODIFIER_IDS[i] = UUID.nameUUIDFromBytes(("reskillable:skill_bonus_" + i).getBytes());
        }
    }
}

